package cn.sh1rocu.touhoulittlemaid.mixin.compat.tacz;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(GunAnimationStateContext.class)
public class GunAnimationStateContextMixin {
    @Shadow
    private class_1799 currentGunItem;

    @Inject(
            remap = false,
            method = "lambda$hasAmmoToConsume$8",
            at = @At("HEAD"),
            cancellable = true
    )
    private void tlm$hasAmmoToConsume(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof EntityMaid maid) {
            var cap = maid.getAllInv();
            // 背包检查
            for (int i = 0; i < cap.getSlots(); i++) {
                class_1799 checkAmmoStack = cap.getStackInSlot(i);
                if (checkAmmoStack.method_7909() instanceof IAmmo iAmmo && iAmmo.isAmmoOfGun(this.currentGunItem, checkAmmoStack)) {
                    cir.setReturnValue(true);
                    return;
                }
                if (checkAmmoStack.method_7909() instanceof IAmmoBox iAmmoBox && iAmmoBox.isAmmoBoxOfGun(this.currentGunItem, checkAmmoStack)) {
                    cir.setReturnValue(true);
                    return;
                }
            }
        }
    }
}
