package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.google.common.net.HttpHeaders;
import com.google.common.net.MediaType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

/**
 * 因为默认推荐的 AI 对话工具是 Player2，所以需要对其做额外判断，提示玩家安装使用
 */
public class Player2AppCheck {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(15);
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder()
            .connectTimeout(MAX_TIMEOUT)
            .version(HttpClient.Version.HTTP_1_1)
            .build();
    private static final HttpRequest REQUEST = HttpRequest.newBuilder()
            .uri(URI.create("http://127.0.0.1:4315/v1/health"))
            .header(HttpHeaders.ACCEPT, MediaType.JSON_UTF_8.toString())
            .header("player2-game-key", "TouhouLittleMaid")
            .timeout(MAX_TIMEOUT)
            .GET().build();

    public static void checkPlayer2App(class_3222 player, Runnable runnable) {
        HTTP_CLIENT.sendAsync(REQUEST, HttpResponse.BodyHandlers.ofString())
                .whenComplete((response, exception) -> {
                    if (exception != null) {
                        sendTip(player);
                        return;
                    }
                    if (response.statusCode() != 200) {
                        player.method_43496(class_2561.method_43469("ai.touhou_little_maid.chat.player2_error", response.statusCode()));
                        return;
                    }
                    if (player.method_5682() != null) {
                        player.method_5682().method_20493(runnable);
                    }
                });
    }

    /**
     * STT 语音识别是在客户端进行的，所以需要在客户端检查 Player2 是否安装
     */
    @Environment(EnvType.CLIENT)
    public static void checkPlayer2AppInStt(class_1657 player, Runnable runnable) {
        HTTP_CLIENT.sendAsync(REQUEST, HttpResponse.BodyHandlers.ofString())
                .whenComplete((response, exception) -> {
                    if (exception != null) {
                        sendTip(player);
                        return;
                    }
                    if (response.statusCode() != 200) {
                        player.method_43496(class_2561.method_43469("ai.touhou_little_maid.chat.player2_error", response.statusCode()));
                        return;
                    }
                    class_310.method_1551().method_20493(runnable);
                });
    }

    private static void sendTip(class_1657 player) {
        class_5250 tip = class_2561.method_43471("ai.touhou_little_maid.chat.need_player2_install")
                .method_27692(class_124.field_1061);
        class_5250 url = class_2561.method_43470("https://player2.game/");
        class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11749, "https://player2.game/");
        class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("chat.link.open"));
        url.method_27694(style -> style.method_10949(hoverEvent).method_10958(clickEvent)
                .method_30938(true).method_10977(class_124.field_1078));
        player.method_43496(tip);
        player.method_43496(class_2561.method_43471("ai.touhou_little_maid.chat.download_url").method_10852(url));
    }
}