package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.DefaultMonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.AttackTaskConfigContainer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4140;
import net.minecraft.class_7923;
import java.util.Optional;

public interface IAttackTask extends IMaidTask {
    String MAID_NO_ATTACK_TAG = "MaidNoAttack";

    /**
     * 寻找合适的第一个攻击目标
     *
     * @param maid 女仆
     * @return 合适的攻击目标
     */
    static Optional<? extends class_1309> findFirstValidAttackTarget(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).flatMap(
                mobs -> mobs.method_38975((e) -> maid.method_18395(e) && maid.method_18407(e.method_24515())));
    }

    /**
     * 能否攻击该对象
     *
     * @param maid   女仆
     * @param target 攻击的目标
     * @return 能否攻击？
     */
    default boolean canAttack(EntityMaid maid, class_1309 target) {
        // 获取实体 ID
        class_2960 id = class_7923.field_41177.method_10221(target.method_5864());

        // 排除一些盔甲架，还有本模组的实体，以及玩家
        if (target instanceof class_1531 || target instanceof AbstractEntityFromItem || target instanceof class_1657) {
            return false;
        }
        // 有主的宠物也不攻击
        if (target instanceof class_1321 tamableAnimal && tamableAnimal.method_6139() != null) {
            return false;
        }
        // 特殊命名的怪物，因为有的玩家会使用怪物做刷怪塔，会被女仆误杀
        if (target.method_5797() != null && target.method_5797().getString().startsWith(MAID_NO_ATTACK_TAG)) {
            return false;
        }

        // 判断配置文件的
        if (MaidConfig.MAID_ATTACK_IGNORE.get().contains(id.toString())) {
            return false;
        }

        MonsterType monsterType;
        AttackListData attackListData = maid.getData(InitTaskData.ATTACK_LIST);
        if (attackListData != null && attackListData.attackGroups().containsKey(id)) {
            // 获取女仆 Task Data 里设置的
            monsterType = attackListData.attackGroups().get(id);
        } else {
            // 那如果没有呢？走默认配置
            monsterType = DefaultMonsterType.getMonsterType(target);
        }
        return DefaultMonsterType.canAttack(maid, target, monsterType);
    }

    /**
     * 是否拥有额外攻击方式，用于一些额外增伤的设计
     * 比如女仆副手持有灭火器，会额外对下界生物造成二次伤害
     *
     * @param maid   女仆
     * @param target 攻击目标
     * @return 是否有额外攻击方式
     */
    default boolean hasExtraAttack(EntityMaid maid, class_1297 target) {
        return false;
    }

    /**
     * 执行额外伤害
     *
     * @param maid   女仆
     * @param target 攻击目标
     * @return 是否成功造成伤害
     */
    default boolean doExtraAttack(EntityMaid maid, class_1297 target) {
        return false;
    }

    /**
     * 是适合的攻击武器么，用于女仆 AI 判断当前武器在当前模式下是否能正常使用
     *
     * @param maid  女仆
     * @param stack 检查的物品
     * @return 在当前模式下是否能正常使用
     */
    default boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return false;
    }

    @Override
    default class_3908 getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.method_5628();
        return new ExtendedScreenHandlerFactory() {
            @Override
            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(entityId);
            }

            @Override
            public class_2561 method_5476() {
                return class_2561.method_43470("Maid Attack Config Container");
            }

            @Override
            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                return new AttackTaskConfigContainer(index, playerInventory, entityId);
            }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

/*            @Override
            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }*/
        };
    }

    @Override
    default boolean enablePanic(EntityMaid maid) {
        return false;
    }
}