package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.WirelessIOButton;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.other.WirelessIOContainer;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.network.message.WirelessIOGuiMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class WirelessIOContainerGui extends class_465<WirelessIOContainer> {
    private static final class_2960 MAIN = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/wireless_io.png");
    private boolean isMaidToChest;
    private boolean isBlacklist;

    public WirelessIOContainerGui(WirelessIOContainer container, class_1661 inv, class_2561 titleIn) {
        super(container, inv, titleIn);
        this.isMaidToChest = ItemWirelessIO.isMaidToChest(container.getWirelessIO());
        this.isBlacklist = ItemWirelessIO.isBlacklist(container.getWirelessIO());
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37067();

        WirelessIOButton ioModeToggle = new WirelessIOButton(field_2776 + 23, field_2800 + 34, 18, 18, isMaidToChest,
                (x, y) -> {
                    isMaidToChest = !isMaidToChest;
                    ClientPlayNetworking.send(WirelessIOGuiMessage.ID, WirelessIOGuiMessage.encode(isMaidToChest, isBlacklist));
                }, (m, x, y) -> m.method_51438(field_22793, class_2561.method_43471("gui.touhou_little_maid.wireless_io.io_mode"), x, y));

        ioModeToggle.initTextureValues(194, 32, -18, 18, MAIN);
        WirelessIOButton filterModeToggle = new WirelessIOButton(field_2776 + 136, field_2800 + 26, 16, 16, isBlacklist,
                (x, y) -> {
                    isBlacklist = !isBlacklist;
                    ClientPlayNetworking.send(WirelessIOGuiMessage.ID, WirelessIOGuiMessage.encode(isMaidToChest, isBlacklist));
                }, (m, x, y) -> m.method_51438(field_22793, class_2561.method_43471("gui.touhou_little_maid.wireless_io.filter_mode"), x, y));
        filterModeToggle.initTextureValues(176, 0, 16, 16, MAIN);

        class_344 configButton = new class_344(field_2776 + 136, field_2800 + 44, 16, 16, 208, 0, 16,
                MAIN, 256, 256, buttons -> Screens.getClient(this).method_1507(new WirelessIOConfigSlotGui(field_2797.getWirelessIO())));
        configButton.method_47400(class_7919.method_47407(class_2561.method_43471("gui.touhou_little_maid.wireless_io.config_slot")));

        method_37063(filterModeToggle);
        method_37063(configButton);
        method_37063(ioModeToggle);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.method_2380(graphics, mouseX, mouseY);
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        super.method_25420(graphics);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, MAIN);
        graphics.method_25302(MAIN, field_2776, field_2800, 0, 0, field_2792, field_2779);
        if (isBlacklist) {
            graphics.method_25302(MAIN, field_2776 + 61, field_2800 + 15, 0, 166, 54, 55);
        }
    }

    @Override
    protected void method_2388(class_332 graphics, int x, int y) {
    }
}
