package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare;

import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.projectile.RgoGrenadeEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.HandGrenade;
import com.atsuishio.superbwarfare.item.RgoGrenade;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidAnimationMessage;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3419;
import net.minecraft.class_3857;
import net.minecraft.class_4215;

import static com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask.targetConditionsTest;
import static com.github.tartaricacid.touhoulittlemaid.network.message.MaidAnimationMessage.SWF_FIRE;
import static com.github.tartaricacid.touhoulittlemaid.network.message.MaidAnimationMessage.SWF_RELOAD;

public class SWarfareCompatInner {
    static boolean isGun(class_1799 stack) {
        return stack.method_7909() instanceof GunItem;
    }

    static boolean isGrenade(class_1799 stack) {
        return stack.method_7909() instanceof HandGrenade;
    }

    static boolean isVehicle(class_1297 entity) {
        return entity instanceof VehicleEntity;
    }

    static boolean shouldHideLivingRender(class_1309 maid) {
        if (maid.method_5854() instanceof VehicleEntity vehicle) {
            return vehicle.hidePassenger(maid);
        }
        return false;
    }

    static boolean canSee(EntityMaid maid, class_1309 target) {
        class_1799 handItem = maid.method_6047();
        if (!(handItem.method_7909() instanceof GunItem)) {
            return class_4215.method_24565(maid, target);
        }
        GunData gunData = GunData.from(handItem);
        if (gunData == null) {
            return maid.canSee(target);
        }
        // 狙击枪？用远距离模式
        if (handItem.method_31573(SWarfareCompat.SNIPER)) {
            return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
        }
        // 霰弹枪？手枪？冲锋枪？近距离模式
        if (handItem.method_31573(SWarfareCompat.PISTOL) || handItem.method_31573(SWarfareCompat.SMG) || handItem.method_31573(SWarfareCompat.SHOOTGUN)) {
            return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
        }
        // 其他情况，中等距离
        return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
    }

    static Optional<Boolean> canVehicleSee(EntityMaid maid, class_1309 target) {
        class_1297 vehicle = maid.method_5854();
        if (vehicle != null && SWarfareCompat.isVehicle(vehicle)) {
            boolean canSee = targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            return Optional.of(canSee);
        }
        class_1309 owner = maid.method_35057();
        // 如果女仆在非一号位，那么 getVehicle 会返回 null
        // 故需要通过此方式判断女仆是否在载具上
        if (owner instanceof class_1657 player) {
            class_1297 playerVehicle = player.method_5854();
            if (playerVehicle != null && playerVehicle.method_5685().contains(maid) && SWarfareCompat.isVehicle(playerVehicle)) {
                boolean canSee = targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
                return Optional.of(canSee);
            }
        }
        return Optional.empty();
    }

    static void tick(EntityMaid shooter, class_1309 target, class_1799 gunItem) {
        if (!(gunItem.method_7909() instanceof GunItem)) {
            return;
        }
        GunData gunData = GunData.from(gunItem);
        if (gunData == null) {
            return;
        }
        gunData.tick(shooter, true);
    }

    static void onStop(EntityMaid maid, GunShootTargetTask task) {
        // 如果女仆副手是手雷，那么 cooldown 设置为 50 tick
        class_1799 offhand = maid.method_6079();
        if (offhand.method_7909() instanceof RgoGrenade) {
            task.setAttackCooldown(50);
        }
    }

    static int performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem) {
        // 再次判断枪械
        if (!(gunItem.method_7909() instanceof GunItem)) {
            return 100;
        }
        GunData gunData = GunData.from(gunItem);
        if (gunData == null) {
            return 100;
        }
        // 先尝试装填弹药
        int result = doGunReload(shooter, gunData);
        if (result > 0) {
            return result;
        }
        // 再尝试开火
        if (!gunData.canShoot(shooter)) {
            // 看看副手有没有 fog 手榴弹，丢手榴弹
            useGrenade(shooter, target);
            return 50;
        }
        return doGunShoot(shooter, target, gunItem, gunData);
    }

    private static void useGrenade(EntityMaid shooter, class_1309 target) {
        class_1799 offhand = shooter.method_6079();
        // 手雷投掷范围有限，限定距离
        if (offhand.method_7909() instanceof RgoGrenade && shooter.method_5739(target) <= 16) {
            setViewRot(shooter, target);
            float power = 1.2f + shooter.method_6051().method_43057() * 0.4f;
            class_3857 rgoGrenade = new RgoGrenadeEntity(shooter, shooter.field_6002, 40);
            rgoGrenade.method_24919(shooter, shooter.method_36455(), shooter.method_36454(), 0, power, 0);
            shooter.field_6002.method_8649(rgoGrenade);
            shooter.field_6002.method_8396(null, shooter.method_24515(), ModSounds.GRENADE_THROW, class_3419.field_15254, 1, 1);
            offhand.method_7934(1);
        }
    }

    private static int doGunReload(EntityMaid shooter, GunData gunData) {
        if (gunData.shouldStartReloading(shooter)) {
            gunData.startReload();
            NetworkHandler.sendToTrackingEntity(shooter, MaidAnimationMessage.ID, MaidAnimationMessage.encode(shooter.method_5628(), SWF_RELOAD));
            return 5;
        }
        if (gunData.shouldStartBolt()) {
            gunData.startBolt();
            NetworkHandler.sendToTrackingEntity(shooter, MaidAnimationMessage.ID, MaidAnimationMessage.encode(shooter.method_5628(), SWF_RELOAD));
            return 5;
        }
        return -1;
    }

    private static int doGunShoot(EntityMaid shooter, class_1309 target, class_1799 gunItem, GunData gunData) {
        // 如果是狙击枪，应用瞄准
        boolean isSniper = gunItem.method_31573(SWarfareCompat.SNIPER);
        if (isSniper && !shooter.isAiming()) {
            shooter.setAiming(true);
            return 20;
        }

        // 如果是非狙击枪，超出 radius 范围，那么也瞄准
        if (!isSniper) {
            float distance = shooter.method_5739(target);
            float radius = shooter.method_18413();
            if (distance <= radius && shooter.isAiming()) {
                shooter.setAiming(false);
                return 10;
            }
            if (distance > radius && !shooter.isAiming()) {
                shooter.setAiming(true);
                return 20;
            }
        }

        // 依据 rpm 计算冷却时间
        double rps = gunData.get(GunProp.RPM) / 60.0;
        int cooldown = (int) Math.round(20 / rps);
        FireMode fireMode = gunData.fireMode.get();
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST && gunData.burstAmount.get() == 0) {
            // 半自动和点射模式，每次开火增加 5-10 tick 的冷却时间
            cooldown += (5 + shooter.method_6051().method_43048(5));
        }

        // 将女仆的 look angle 设置好
        setViewRot(shooter, target);
        // 开火
        gunData.shoot(shooter, 0, shooter.isAiming(), target.method_5667());

        // 播放开火动作
        NetworkHandler.sendToTrackingEntity(shooter, MaidAnimationMessage.ID, MaidAnimationMessage.encode(shooter.method_5628(), SWF_FIRE));
        return cooldown;
    }

    private static void setViewRot(EntityMaid shooter, class_1309 target) {
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();
        float yaw = (float) -Math.toDegrees(Math.atan2(x, z));
        float pitch = (float) -Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z)));

        // 因为开火方向和实体视线方向一致，故需要强制指定
        shooter.method_36457(pitch);
        shooter.method_36456(yaw);
    }
}