package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.client;

import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import javax.annotation.Nullable;

@Environment(EnvType.CLIENT)
public class GunBaseAnimation {
    public static boolean onHoldGun(IMaid maid, @Nullable ModelRendererWrapper armLeft, @Nullable ModelRendererWrapper armRight) {
        class_1308 mob = maid.asEntity();
        if (mob == null) {
            return false;
        }
        class_1799 handItem = mob.method_6047();
        if (!(handItem.method_7909() instanceof GunItem)) {
            return false;
        }
        class_2960 gunId = class_7923.field_41178.method_10221(handItem.method_7909());
        if (gunId == class_7923.field_41178.method_10137()) {
            return false;
        }

        // 因为现在还没有 minigun 的专属标签，故只能用特判
        if (gunId.equals(SWarfareCompat.MINIGUN_ID) || gunId.equals(SWarfareCompat.M_2_HB_ID)) {
            if (armLeft != null) {
                armLeft.setRotateAngleX(-1.45f);
                armLeft.setRotateAngleY(1f);
            }
            if (armRight != null) {
                armRight.setRotateAngleX(0.75f);
                armRight.setRotateAngleY(0);
            }
            return true;
        }

        if (armLeft != null) {
            armLeft.setRotateAngleX(-1.75f);
            armLeft.setRotateAngleY(0.5f);
        }
        if (armRight != null) {
            armRight.setRotateAngleX(-1.65f);
            armRight.setRotateAngleY(-0.174f);
        }
        return true;
    }
}