package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4816;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;
import net.minecraft.world.entity.ai.behavior.*;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class MeleeTaskJS implements IAttackTask {
    private final Builder builder;

    public MeleeTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public class_2960 getUid() {
        return this.builder.id;
    }

    @Override
    public class_1799 getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        if (this.builder.sound == null) {
            return SoundUtil.attackSound(maid, InitSounds.MAID_ATTACK, 0.5f);
        }
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(m ->
                isWeapon(m, m.method_6047()), IAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138(target ->
                !isWeapon(maid, maid.method_6047()) || maid.method_5739(target) > maid.method_18413());
        class_7893<class_1308> moveToTargetTask = class_4822.method_47094(builder.walkSpeed);
        class_7893<class_1308> attackTargetTask = class_4816.method_46987(builder.meleeCooldownTick);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();

        List<Pair<Integer, class_7893<? super EntityMaid>>> tasks = Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, moveToTargetTask),
                Pair.of(5, attackTargetTask),
                Pair.of(5, maidUseShieldTask));

        for (var pair : this.builder.brains) {
            tasks.add(Pair.of(pair.getFirst(), pair.getSecond().apply(this, maid)));
        }
        return tasks;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(m ->
                isWeapon(m, m.method_6047()), IAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138(target ->
                !isWeapon(maid, maid.method_6047()) || farAway(target, maid));
        class_7893<class_1308> attackTargetTask = class_4816.method_46987(builder.meleeCooldownTick);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();

        List<Pair<Integer, class_7893<? super EntityMaid>>> tasks = Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, attackTargetTask),
                Pair.of(5, maidUseShieldTask));

        for (var pair : this.builder.rideBrains) {
            tasks.add(Pair.of(pair.getFirst(), pair.getSecond().apply(this, maid)));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return true;
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean isHidden(EntityMaid maid) {
        if (this.builder.isHidden == null) {
            return false;
        }
        return this.builder.isHidden.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return true;
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return true;
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    @Override
    public boolean canAttack(EntityMaid maid, class_1309 target) {
        if (this.builder.canAttack == null) {
            return IAttackTask.super.canAttack(maid, target);
        }
        return this.builder.canAttack.test(maid, target);
    }

    @Override
    public boolean hasExtraAttack(EntityMaid maid, class_1297 target) {
        if (this.builder.hasExtraAttack == null) {
            return false;
        }
        return this.builder.hasExtraAttack.test(maid, target);
    }

    @Override
    public boolean doExtraAttack(EntityMaid maid, class_1297 target) {
        if (this.builder.doExtraAttack == null) {
            return false;
        }
        return this.builder.doExtraAttack.test(maid, target);
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        if (this.builder.isWeapon == null) {
            return false;
        }
        return this.builder.isWeapon.test(maid, stack);
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        if (!target.method_5805()) {
            return true;
        }
        boolean enable = maid.isHomeModeEnable();
        float radius = maid.method_18413();
        if (!enable && maid.method_35057() != null) {
            return maid.method_35057().method_5739(target) > radius;
        }
        return maid.method_5739(target) > radius;
    }

    public static class Builder extends TaskBuilder<Builder, MeleeTaskJS> {
        private @Nullable BiPredicate<EntityMaid, class_1309> canAttack = null;
        private @Nullable BiPredicate<EntityMaid, class_1297> hasExtraAttack = null;
        private @Nullable BiPredicate<EntityMaid, class_1297> doExtraAttack = null;
        private @Nullable BiPredicate<EntityMaid, class_1799> isWeapon = null;
        private float walkSpeed = 0.6f;
        private int meleeCooldownTick = 20;

        public Builder(class_2960 id, class_1799 icon) {
            super(id, icon);
        }

        @Info(value = """
                Sets the condition for whether the maid can attack a target. Default is all hostile entities. <br>
                设置女仆是否可以攻击目标的条件。默认为所有敌对生物。
                """)
        public Builder canAttack(BiPredicate<EntityMaid, class_1309> canAttack) {
            this.canAttack = canAttack;
            return this;
        }

        @Info(value = """
                Sets the condition for whether the maid has an extra attack against a target. Default is false. <br>
                设置女仆是否对目标有额外攻击的条件。默认为 false。
                """)
        public Builder hasExtraAttack(BiPredicate<EntityMaid, class_1297> hasExtraAttack) {
            this.hasExtraAttack = hasExtraAttack;
            return this;
        }

        @Info(value = """
                Sets the action for the maid to perform an extra attack against a target. Default is empty. <br>
                设置女仆对目标执行额外攻击的动作。默认为空。
                """)
        public Builder doExtraAttack(BiPredicate<EntityMaid, class_1297> doExtraAttack) {
            this.doExtraAttack = doExtraAttack;
            return this;
        }

        @Info(value = """
                Sets the condition for whether the maid considers an item as a weapon. Mandatory. <br>
                设置女仆是否将当前物品视为武器的条件。必填项。
                """)
        public Builder isWeapon(BiPredicate<EntityMaid, class_1799> isWeapon) {
            this.isWeapon = isWeapon;
            return this;
        }

        @Info(value = """
                Sets the walk speed for the maid when moving towards a target. Default is 0.6. <br>
                设置女仆在接近目标时的移动速度。默认为 0.6。
                """)
        public Builder walkSpeed(float walkSpeed) {
            this.walkSpeed = walkSpeed;
            return this;
        }

        @Info(value = """
                Sets the cooldown tick for the attack. Default is 20 ticks. <br>
                设置攻击的冷却时间（以 tick 为单位）。默认值为 20 ticks。
                """)
        public Builder meleeCooldownTick(int meleeCooldownTick) {
            this.meleeCooldownTick = meleeCooldownTick;
            return this;
        }
    }
}

