package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain;

import com.github.tartaricacid.touhoulittlemaid.api.entity.ai.IExtraMaidBrain;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ride.MaidRideBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.*;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1299;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4119;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4818;
import net.minecraft.class_7893;
import net.minecraft.world.entity.ai.behavior.*;
import java.util.List;
import java.util.function.Predicate;

public final class MaidBrain {
    public static ImmutableList<class_4140<?>> getMemoryTypes() {
        List<class_4140<?>> defaultTypes = Lists.newArrayList(
                class_4140.field_18449,
                class_4140.field_26389,
                class_4140.field_18446,
                class_4140.field_18453,
                class_4140.field_18451,
                class_4140.field_18452,
                class_4140.field_19293,
                class_4140.field_18445,
                class_4140.field_22355,
                class_4140.field_22475,
                InitEntities.TARGET_POS
        );
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> defaultTypes.addAll(extra.getExtraMemoryTypes()));
        return ImmutableList.copyOf(defaultTypes);
    }

    public static ImmutableList<class_4149<? extends class_4148<? super EntityMaid>>> getSensorTypes() {
        List<class_4149<? extends class_4148<? super EntityMaid>>> defaultTypes = Lists.newArrayList(
                InitEntities.MAID_NEAREST_LIVING_ENTITY_SENSOR,
                class_4149.field_18469,
                InitEntities.MAID_HOSTILES_SENSOR,
                InitEntities.MAID_PICKUP_ENTITIES_SENSOR
        );
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> defaultTypes.addAll(extra.getExtraSensorTypes()));
        return ImmutableList.copyOf(defaultTypes);
    }

    public static void registerBrainGoals(class_4095<EntityMaid> brain, EntityMaid maid) {
        registerSchedule(brain, maid);
        registerCoreGoals(brain);
        registerPanicGoals(brain);

        registerRideIdleGoals(brain);
        registerRideWorkGoals(brain, maid);
        registerRideRestGoals(brain);

        registerIdleGoals(brain);
        registerWorkGoals(brain, maid);
        registerRestGoals(brain);

        brain.method_18890(ImmutableSet.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24526(class_4168.field_18595);
        MaidUpdateActivityFromSchedule.updateActivityFromSchedule(maid, brain);
    }

    private static void registerSchedule(class_4095<EntityMaid> brain, EntityMaid maid) {
        switch (maid.getSchedule()) {
            case ALL:
                brain.method_18884(InitEntities.MAID_ALL_DAY_SCHEDULES);
                break;
            case NIGHT:
                brain.method_18884(InitEntities.MAID_NIGHT_SHIFT_SCHEDULES);
                break;
            case DAY:
            default:
                brain.method_18884(InitEntities.MAID_DAY_SHIFT_SCHEDULES);
                break;
        }
    }

    private static void registerCoreGoals(class_4095<EntityMaid> brain) {
        Pair<Integer, class_7893<? super EntityMaid>> swimJump = Pair.of(0, new MaidSwimJumpTask(0.8f));
        Pair<Integer, class_7893<? super EntityMaid>> breathAir = Pair.of(0, new MaidBreathAirTask());
        Pair<Integer, class_7893<? super EntityMaid>> breathAirStop = Pair.of(0, new MaidBreathAirStopTask());
        Pair<Integer, class_7893<? super EntityMaid>> climb = Pair.of(0, new MaidClimbTask());
        Pair<Integer, class_7893<? super EntityMaid>> look = Pair.of(0, new class_4110(45, 90));
        Pair<Integer, class_7893<? super EntityMaid>> maidPanic = Pair.of(1, new MaidPanicTask());
        Pair<Integer, class_7893<? super EntityMaid>> maidAwait = Pair.of(1, new MaidAwaitTask());
        Pair<Integer, class_7893<? super EntityMaid>> interactWithDoor = Pair.of(2, MaidInteractWithDoor.create());
        Pair<Integer, class_7893<? super EntityMaid>> walkToTarget = Pair.of(2, new class_4112());
        Pair<Integer, class_7893<? super EntityMaid>> followOwner = Pair.of(3, new MaidFollowOwnerTask(0.5f, 2));
        Pair<Integer, class_7893<? super EntityMaid>> followOwnerVehicle = Pair.of(3, new MaidFollowOwnerVehicleTask(0.5f, 2));
        Pair<Integer, class_7893<? super EntityMaid>> healSelf = Pair.of(3, new MaidHealSelfTask());
        Pair<Integer, class_7893<? super EntityMaid>> pickupItem = Pair.of(10, new MaidPickupEntitiesTask(EntityMaid::isPickup, 0.6f));
        Pair<Integer, class_7893<? super EntityMaid>> clearSleep = Pair.of(99, new MaidClearSleepTask());

        List<Pair<Integer, class_7893<? super EntityMaid>>> behaviors = Lists.newArrayList(swimJump, climb, breathAir, breathAirStop,
                look, maidPanic, maidAwait, interactWithDoor, walkToTarget, followOwner, followOwnerVehicle, healSelf, pickupItem, clearSleep);
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getCoreBehaviors()));
        brain.method_18881(class_4168.field_18594, ImmutableList.copyOf(behaviors));
    }

    private static void registerIdleGoals(class_4095<EntityMaid> brain) {
        Pair<Integer, class_7893<? super EntityMaid>> beg = Pair.of(5, new MaidBegTask());
        Pair<Integer, class_7893<? super EntityMaid>> homeMeal = Pair.of(6, new MaidFindHomeMealTask(0.6f, 2));
        Pair<Integer, class_7893<? super EntityMaid>> joy = Pair.of(7, new MaidJoyTask(0.6f, 2));
        Pair<Integer, class_7893<? super EntityMaid>> supplemented = Pair.of(20, getLookAndRandomWalk(maid -> !maid.getSwimManager().isGoingToBreath()));
        Pair<Integer, class_7893<? super EntityMaid>> updateActivity = Pair.of(99, new MaidUpdateActivityFromSchedule());

        List<Pair<Integer, class_7893<? super EntityMaid>>> behaviors = Lists.newArrayList(beg, homeMeal, joy, supplemented, updateActivity);
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getIdleBehaviors()));
        brain.method_18881(class_4168.field_18595, ImmutableList.copyOf(behaviors));
    }

    private static void registerWorkGoals(class_4095<EntityMaid> brain, EntityMaid maid) {
        Pair<Integer, class_7893<? super EntityMaid>> updateActivity = Pair.of(99, new MaidUpdateActivityFromSchedule());
        IMaidTask task = maid.getTask();
        List<Pair<Integer, class_7893<? super EntityMaid>>> pairMaidList = task.createBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList(updateActivity);
        } else {
            pairMaidList.add(updateActivity);
        }
        pairMaidList.add(Pair.of(6, new MaidBegTask()));
        pairMaidList.add(Pair.of(7, new MaidWorkMealTask()));
        pairMaidList.add(Pair.of(20, getLookAndRandomWalk(e -> e.getTask().enableLookAndRandomWalk(e) && !e.getSwimManager().isGoingToBreath())));

        for (IExtraMaidBrain extra : ExtraMaidBrainManager.EXTRA_MAID_BRAINS) {
            pairMaidList.addAll(extra.getWorkBehaviors());
        }
        brain.method_18881(class_4168.field_18596, ImmutableList.copyOf(pairMaidList));
    }

    private static void registerRestGoals(class_4095<EntityMaid> brain) {
        Pair<Integer, class_7893<? super EntityMaid>> bed = Pair.of(5, new MaidBedTask(0.6f, 2));
        Pair<Integer, class_7893<? super EntityMaid>> supplemented = Pair.of(20, getLookAndRandomWalk(maid -> true));
        Pair<Integer, class_7893<? super EntityMaid>> updateActivity = Pair.of(99, new MaidUpdateActivityFromSchedule());

        List<Pair<Integer, class_7893<? super EntityMaid>>> behaviors = Lists.newArrayList(bed, supplemented, updateActivity);
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRestBehaviors()));
        brain.method_18881(class_4168.field_18597, ImmutableList.copyOf(behaviors));
    }

    private static void registerPanicGoals(class_4095<EntityMaid> brain) {
        Pair<Integer, class_7893<? super EntityMaid>> clearHurt = Pair.of(5, new MaidClearHurtTask());
        Pair<Integer, class_7893<? super EntityMaid>> runAway = Pair.of(5, MaidRunAwayTask.entity(class_4140.field_18453, 0.7f, false));

        List<Pair<Integer, class_7893<? super EntityMaid>>> behaviors = Lists.newArrayList(clearHurt, runAway);
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getPanicBehaviors()));
        brain.method_18881(class_4168.field_18599, ImmutableList.copyOf(behaviors));
    }

    private static void registerRideIdleGoals(class_4095<EntityMaid> brain) {
        Pair<Integer, class_7893<? super EntityMaid>> beg = Pair.of(4, new MaidRideBegTask());
        Pair<Integer, class_7893<? super EntityMaid>> homeMeal = Pair.of(5, new MaidHomeMealTask());
        Pair<Integer, class_7893<? super EntityMaid>> look = Pair.of(6, getLook(maid -> true));
        Pair<Integer, class_7893<? super EntityMaid>> updateActivity = Pair.of(99, new MaidUpdateActivityFromSchedule());

        List<Pair<Integer, class_7893<? super EntityMaid>>> behaviors = Lists.newArrayList(beg, homeMeal, look, updateActivity);
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRideIdleBehaviors()));
        brain.method_18881(InitEntities.RIDE_IDLE, ImmutableList.copyOf(behaviors));
    }

    private static void registerRideWorkGoals(class_4095<EntityMaid> brain, EntityMaid maid) {
        Pair<Integer, class_7893<? super EntityMaid>> updateActivity = Pair.of(99, new MaidUpdateActivityFromSchedule());
        IMaidTask task = maid.getTask();
        List<Pair<Integer, class_7893<? super EntityMaid>>> pairMaidList = task.createRideBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList(updateActivity);
        } else {
            pairMaidList.add(updateActivity);
        }
        pairMaidList.add(Pair.of(6, new MaidRideBegTask()));
        pairMaidList.add(Pair.of(7, new MaidWorkMealTask()));
        pairMaidList.add(Pair.of(20, getLook(e -> e.getTask().enableLookAndRandomWalk(e))));

        for (IExtraMaidBrain extra : ExtraMaidBrainManager.EXTRA_MAID_BRAINS) {
            pairMaidList.addAll(extra.getRideWorkBehaviors());
        }
        brain.method_18881(InitEntities.RIDE_WORK, ImmutableList.copyOf(pairMaidList));
    }

    private static void registerRideRestGoals(class_4095<EntityMaid> brain) {
        Pair<Integer, class_7893<? super EntityMaid>> updateActivity = Pair.of(99, new MaidUpdateActivityFromSchedule());
        List<Pair<Integer, class_7893<? super EntityMaid>>> behaviors = Lists.newArrayList(updateActivity);
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRideRestBehaviors()));
        brain.method_18881(InitEntities.RIDE_REST, ImmutableList.copyOf(behaviors));
    }

    private static MaidRunOne getLookAndRandomWalk(Predicate<EntityMaid> enableCondition) {
        Pair<class_7893<? super EntityMaid>, Integer> lookToPlayer = Pair.of(class_4119.method_47057(class_1299.field_6097, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToMaid = Pair.of(class_4119.method_47057(EntityMaid.TYPE, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToWolf = Pair.of(class_4119.method_47057(class_1299.field_6055, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToCat = Pair.of(class_4119.method_47057(class_1299.field_16281, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToParrot = Pair.of(class_4119.method_47057(class_1299.field_6104, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> walkRandomly = Pair.of(class_4818.method_47015(0.3f, 5, 3), 1);
        Pair<class_7893<? super EntityMaid>, Integer> noLook = Pair.of(new class_4101(30, 60), 2);
        return new MaidRunOne(ImmutableList.of(lookToPlayer, lookToMaid, lookToWolf, lookToCat, lookToParrot, walkRandomly, noLook), enableCondition);
    }

    private static MaidRunOne getLook(Predicate<EntityMaid> enableCondition) {
        Pair<class_7893<? super EntityMaid>, Integer> lookToPlayer = Pair.of(class_4119.method_47057(class_1299.field_6097, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToMaid = Pair.of(class_4119.method_47057(EntityMaid.TYPE, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToWolf = Pair.of(class_4119.method_47057(class_1299.field_6055, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToCat = Pair.of(class_4119.method_47057(class_1299.field_16281, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> lookToParrot = Pair.of(class_4119.method_47057(class_1299.field_6104, 5), 1);
        Pair<class_7893<? super EntityMaid>, Integer> noLook = Pair.of(new class_4101(30, 60), 2);
        return new MaidRunOne(ImmutableList.of(lookToPlayer, lookToMaid, lookToWolf, lookToCat, lookToParrot, noLook), enableCondition);
    }
}