package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import cn.sh1rocu.touhoulittlemaid.util.block.BlockUtil;
import cn.sh1rocu.touhoulittlemaid.util.forge.ForgeHooks;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_7;
import net.minecraft.class_9;

/**
 * 该方法仅修改了栅栏门和梯子的寻路判断
 */
public class MaidNodeEvaluator extends class_14 {
    @Override
    public class_7 method_17(class_1922 level, int pX, int pY, int pZ) {
        return getMaidBlockPathTypeStatic(level, new class_2338.class_2339(pX, pY, pZ));
    }

    @Override
    public int method_18(class_9[] outputArray, class_9 node) {
        int nodeId = super.method_18(outputArray, node);
        return this.createClimbNode(nodeId, outputArray, node);
    }

    // 将可爬行物加入寻路节点里头
    // 一般这些物体都是相连的，所以向上向下搜寻下
    protected int createClimbNode(int nodeId, class_9[] nodes, class_9 origin) {
        // 只有在开启攀爬能力，才将梯子加入寻路节点里
        if (this.field_33 instanceof EntityMaid maid && maid.getConfigManager().isActiveClimbing()) {
            // 向上搜寻
            class_2338.class_2339 upPos = new class_2338.class_2339(origin.field_40, origin.field_39 + 1, origin.field_38);
            if (isMaidCanClimbBlock(upPos, maid)) {
                class_9 node = this.method_27137(upPos);
                if (!node.field_42) {
                    node.field_43 = 0;
                    node.field_41 = class_7.field_12;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
            // 向下搜寻
            class_2338.class_2339 downPos = new class_2338.class_2339(origin.field_40, origin.field_39 - 1, origin.field_38);
            if (isMaidCanClimbBlock(downPos, maid)) {
                class_9 node = this.method_27137(downPos);
                if (!node.field_42) {
                    node.field_43 = 0;
                    node.field_41 = class_7.field_12;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
        }
        return nodeId;
    }

    private class_7 getMaidBlockPathTypeStatic(class_1922 level, class_2338.class_2339 pos) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();

        class_7 type = getMaidBlockPathTypeRaw(level, pos);
        if (type == class_7.field_7 && y >= level.method_31607() + 1) {
            class_7 typeBelow = getMaidBlockPathTypeRaw(level, pos.method_10103(x, y - 1, z));

            type = typeBelow != class_7.field_12
                    && typeBelow != class_7.field_7
                    && typeBelow != class_7.field_18
                    && typeBelow != class_7.field_14 ? class_7.field_12 : class_7.field_7;

            if (typeBelow == class_7.field_3) {
                type = class_7.field_3;
            }

            if (typeBelow == class_7.field_17) {
                type = class_7.field_17;
            }

            if (typeBelow == class_7.field_21326) {
                type = class_7.field_21326;
            }

            if (typeBelow == class_7.field_33534) {
                type = class_7.field_36432;
            }

            if (typeBelow == class_7.field_43351) {
                type = class_7.field_43351;
            }
        }

        if (type == class_7.field_12) {
            type = method_59(level, pos.method_10103(x, y, z), type);
        }

        return type;
    }

    private class_7 getMaidBlockPathTypeRaw(class_1922 level, class_2338 pos) {
        // 女仆在限定范围内寻路寻到了范围外，失败
        if (this.field_33 instanceof EntityMaid maid && maid.method_18411() && !maid.method_18407(pos)) {
            return class_7.field_22;
        }
        class_2680 blockState = level.method_8320(pos);
        class_7 pathType = BlockUtil.getBlockPathType(blockState, level, pos, null);
        if (pathType != null) {
            return pathType;
        } else if (blockState.method_26215()) {
            return class_7.field_7;
        } else if (blockState.method_26204() instanceof class_2349) {
            pathType = blockState.method_11654(class_2349.field_11026) ? class_7.field_15 : class_7.field_23;
        } else if (this.field_33 instanceof EntityMaid maid && this.canClimb(blockState, pos, maid)) {
            // 将楼梯视为可行走方块，便于后续将楼梯加入路径节点
            pathType = class_7.field_12;
        } else {
            pathType = class_14.method_58(level, pos);
            // 判断目标方块的碰撞高度。有些半透明方块拥有超过 0.5（台阶）的高度，此时女仆是不能从其中穿过的，需要将其视为不可通行方块
            if (!heightCheckExclusions(pathType)) {
                class_265 shape = blockState.method_26220(level, pos);
                if (pathType != class_7.field_22 && shape.method_1105(class_2350.class_2351.field_11052) - shape.method_1091(class_2350.class_2351.field_11052) > 0.5) {
                    pathType = class_7.field_22;
                }
            }
        }
        if (pathType == class_7.field_23 && this.field_33 instanceof EntityMaid maid && !this.canOpenDoor(blockState.method_26204(), maid)) {
            pathType = class_7.field_8;
        }
        return pathType;
    }

    private boolean heightCheckExclusions(class_7 pathType) {
        return pathType == class_7.field_15 || pathType == class_7.field_23;
    }

    private boolean canOpenDoor(class_2248 block, EntityMaid maid) {
        if (block instanceof class_2323) {
            return maid.getConfigManager().isOpenDoor();
        }
        if (block instanceof class_2349) {
            return maid.getConfigManager().isOpenFenceGate();
        }
        return true;
    }

    private boolean canClimb(class_2680 blockState, class_2338 blockPos, EntityMaid maid) {
        if (isMaidCanClimbBlock(blockState, blockPos, maid)) {
            return maid.getConfigManager().isActiveClimbing();
        }
        return false;
    }

    public static boolean isMaidCanClimbBlock(class_2338 blockPos, EntityMaid maid) {
        class_1937 level = maid.field_6002;
        class_2680 blockState = level.method_8320(blockPos);
        return isMaidCanClimbBlock(blockState, blockPos, maid);
    }

    public static boolean isMaidCanClimbBlock(class_2680 blockState, class_2338 blockPos, EntityMaid maid) {
        return ForgeHooks.isLadder(blockState, maid.field_6002, blockPos, maid);
    }
}