package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSnowballTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidStartSnowballAttacking;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4140;
import net.minecraft.class_7893;
import java.util.List;
import java.util.Optional;

public class TaskIdle implements IMaidTask {
    public static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "idle");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8153.method_7854();
    }

    @Nullable
    @Override
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, InitSounds.MAID_IDLE, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        Pair<Integer, class_7893<? super EntityMaid>> findSnowballTarget = Pair.of(6, new MaidStartSnowballAttacking<>(this::canSnowballFight, this::findFirstValidSnowballTarget));
        Pair<Integer, class_7893<? super EntityMaid>> snowballFight = Pair.of(7, new MaidSnowballTargetTask(50));
        return Lists.newArrayList(findSnowballTarget, snowballFight);
    }

    private boolean canSnowballFight(EntityMaid maid) {
        class_1937 world = maid.method_37908();
        class_2338 pos = maid.method_24515();
        return !maid.isBegging() && world.method_23753(pos).comp_349().method_33599(pos) && world.method_8320(pos).method_27852(class_2246.field_10477);
    }

    private Optional<? extends class_1309> findFirstValidSnowballTarget(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).flatMap(
                list -> list.method_38980(e -> isSnowballTarget(e, maid))
                        .filter(e -> maid.method_18407(e.method_24515()))
                        .findFirst());
    }

    private boolean isSnowballTarget(class_1309 entity, EntityMaid maid) {
        if (maid.method_6171(entity)) {
            return true;
        }
        if (entity instanceof EntityMaid maidOther && maid.method_35057() != null) {
            return maid.method_35057().equals(maidOther.method_35057());
        }
        return false;
    }
}
