package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.google.common.collect.Maps;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import java.util.Map;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class SetAttackListMessage {
    public static final class_2960 ID = getResourceLocation("set_attack_list");

    public static class_2540 encode(int entityId, Map<class_2960, MonsterType> attackGroups) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entityId);
        buf.method_10804(attackGroups.size());
        for (class_2960 id : attackGroups.keySet()) {
            buf.method_10812(id);
            buf.method_10817(attackGroups.get(id));
        }
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 sender, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        Map<class_2960, MonsterType> attackGroupsOutput = Maps.newHashMap();
        int size = buf.method_10816();
        for (int i = 0; i < size; i++) {
            class_2960 id = buf.method_10810();
            MonsterType type = buf.method_10818(MonsterType.class);
            attackGroupsOutput.put(id, type);
        }
        server.execute(() -> writeList(entityId, attackGroupsOutput, sender));
    }

    private static void writeList(int entityId, Map<class_2960, MonsterType> attackGroups, class_1657 sender) {
        class_1297 entity = sender.field_6002.method_8469(entityId);
        if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
            maid.setAndSyncData(InitTaskData.ATTACK_LIST, new AttackListData(attackGroups));
        }
    }
}
