package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_5819;

public final class TeleportHelper {
    public static boolean teleport(EntityMaid maid) {
        if (!maid.field_6002.method_8608() && maid.method_5805()) {
            double x = maid.method_23317() + (maid.method_6051().method_43058() - 0.5) * 16;
            double y = maid.method_23318() + maid.method_6051().method_43048(16) - 8;
            double z = maid.method_23321() + (maid.method_6051().method_43058() - 0.5) * 16;
            return teleport(maid, x, y, z);
        } else {
            return false;
        }
    }

    public static boolean teleportToRestrictCenter(EntityMaid maid) {
        class_2338 blockPos = maid.method_18412();
        if (!maid.field_6002.method_8608() && maid.method_5805()) {
            int x = blockPos.method_10263() + randomIntInclusive(maid.method_6051(), -3, 3);
            // 防止有人搭建二楼，所以向上搜索
            int y = blockPos.method_10264() + randomIntInclusive(maid.method_6051(), 0, 3);
            int z = blockPos.method_10260() + randomIntInclusive(maid.method_6051(), -3, 3);
            return teleport(maid, x, y, z);
        } else {
            return false;
        }
    }

    private static boolean teleport(EntityMaid maid, double x, double y, double z) {
        class_2338.class_2339 blockPos = new class_2338.class_2339(x, y, z);
        while (blockPos.method_10264() > maid.field_6002.method_31607() && !maid.field_6002.method_8320(blockPos).method_51366()) {
            blockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = maid.field_6002.method_8320(blockPos);
        boolean isMotion = blockState.method_51366();
        boolean isWater = blockState.method_26227().method_15767(class_3486.field_15517);
        if (isMotion && !isWater) {
            boolean teleportIsSuccess = maid.method_6082(x, y, z, true);
            if (teleportIsSuccess && !maid.method_5701()) {
                maid.field_6002.method_43128(null, maid.field_6014, maid.field_6036, maid.field_5969, class_3417.field_14879, maid.method_5634(), 1.0F, 1.0F);
                maid.method_5783(class_3417.field_14879, 1.0F, 1.0F);
            }
            return teleportIsSuccess;
        } else {
            return false;
        }
    }

    private static int randomIntInclusive(class_5819 random, int min, int max) {
        return random.method_43048(max - min + 1) + min;
    }
}
