package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1309;

public class LivingAttackEvent extends CancellableEvent {
    private final class_1309 livingEntity;
    private final class_1282 source;
    private final float amount;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback e : callbacks)
            e.onLivingAttack(event);
    });

    public LivingAttackEvent(class_1309 entity, class_1282 source, float amount) {
        this.livingEntity = entity;
        this.source = source;
        this.amount = amount;
    }

    public class_1309 getEntity() {
        return livingEntity;
    }

    public class_1282 getSource() {
        return source;
    }

    public float getAmount() {
        return amount;
    }

    public interface Callback {
        void onLivingAttack(LivingAttackEvent event);
    }
}