package com.github.tartaricacid.simplebedrockmodel.client.manager;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.AbstractBedrockEntityModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import java.io.InputStream;
import java.util.function.Function;

@Environment(EnvType.CLIENT)
public class BedrockEntityModelRegisterEvent<T extends AbstractBedrockEntityModel<? extends class_1297>> {
    private final BedrockEntityModelSet<T> modelSet;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        @SuppressWarnings("rawtypes")
        void post(BedrockEntityModelRegisterEvent event);
    }

    public BedrockEntityModelRegisterEvent(BedrockEntityModelSet<T> modelSet) {
        this.modelSet = modelSet;
    }

    public void register(class_2960 location, Function<InputStream, T> function) {
        this.modelSet.addModel(location, function);
    }
}
