package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class MaidTabButton extends class_4185 implements ITooltipButton {
    private static final class_2960 SIDE = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/maid_gui_side.png");
    private final int left;
    private final List<class_2561> tooltips;

    public MaidTabButton(int x, int y, int left, String key, class_4241 onPressIn) {
        //super(Button.builder(Component.empty(), onPressIn).pos(x, y).size(24, 26));
        super(x, y, 24, 26, class_2561.method_43473(), onPressIn, class_4185.field_40754);
        this.left = left;
        this.tooltips = Lists.newArrayList(
                class_2561.method_43471("gui.touhou_little_maid.button." + key),
                class_2561.method_43471("gui.touhou_little_maid.button." + key + ".desc")
        );
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        if (!this.field_22763) {
            graphics.method_25290(SIDE, this.method_46426(), this.method_46427(), left, 21, this.field_22758, this.field_22759, 256, 256);
        }
        graphics.method_25290(SIDE, this.method_46426() + 4, this.method_46427() + 6, left, 47, 16, 16, 256, 256);
    }

    @Override
    public boolean isTooltipHovered() {
        return this.field_22763 && this.method_49606();
    }

    @Override
    public void renderTooltip(class_332 graphics, class_310 mc, int mouseX, int mouseY) {
        class_327 font = class_310.method_1551().field_1772;
        graphics.method_51434(font, tooltips, mouseX, mouseY);
    }
}