package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.sound.data.SoundData;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class SoundElementButton extends FlatColorButton {
    private final class_2960 soundEvent;
    private final int soundCount;
    private final boolean otherColor;

    public SoundElementButton(int pX, int pY, int pWidth, int pHeight, class_2960 soundEvent, List<SoundData> sounds, boolean otherColor, class_4241 pOnPress) {
        super(pX, pY, pWidth, pHeight, class_2561.method_43471(soundEvent.method_42093("button")), pOnPress);
        this.soundEvent = soundEvent;
        this.soundCount = sounds.size();
        this.otherColor = otherColor;
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        class_310 minecraft = class_310.method_1551();
        if (otherColor) {
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0x5f_9e9e9e, 0x5f_9e9e9e);
        } else {
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xff_434242, 0xff_434242);
        }
        if (this.method_25367()) {
            graphics.method_25296(this.method_46426(), this.method_46427() + 1, this.method_46426() + 1, this.method_46427() + this.field_22759 - 1, 0xff_F3EFE0, 0xff_F3EFE0);
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + 1, 0xff_F3EFE0, 0xff_F3EFE0);
            graphics.method_25296(this.method_46426() + this.field_22758 - 1, this.method_46427() + 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759 - 1, 0xff_F3EFE0, 0xff_F3EFE0);
            graphics.method_25296(this.method_46426(), this.method_46427() + this.field_22759 - 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xff_F3EFE0, 0xff_F3EFE0);
        }
        //int i = getFGColor();
        int i = this.field_22763 ? 16777215 : 10526880;
        this.method_48589(graphics, minecraft.field_1772, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    @Override
    public void method_48589(class_332 graphics, class_327 font, int pColor) {
        graphics.method_25303(font, "▷", this.method_46426() + 5, this.method_46427() + (this.field_22759 - 8) / 2, 0xe0e0e0);
        graphics.method_27535(font, this.method_25369(), this.method_46426() + 15, this.method_46427() + (this.field_22759 - 8) / 2, 0xfafafa);
        String countText = soundCount + "♫";
        int countTextWidth = font.method_1727(countText);
        graphics.method_25303(font, countText, this.method_46426() + this.method_25368() - countTextWidth - 5, this.method_46427() + (this.field_22759 - 8) / 2, 0xCCCCCC);
    }

    public class_2960 getSoundEvent() {
        return soundEvent;
    }
}
