package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1088;
import net.minecraft.class_1308;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5599;
import net.minecraft.class_6880;
import net.minecraft.class_7833;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.MAID_BANNER;

public class LayerMaidBanner extends class_3887<class_1308, BedrockModel<class_1308>> {
    private static final class_2960 TEXTURE = new class_2960(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/maid_banner.png");
    private final EntityMaidRenderer renderer;
    private final SimpleBedrockModel<EntityMaid> bannerModel;

    public LayerMaidBanner(EntityMaidRenderer renderer, class_5599 modelSet) {
        super(renderer);
        this.renderer = renderer;
        this.bannerModel = Objects.requireNonNull(BedrockModelLoader.getModel(MAID_BANNER));
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 bufferIn, int packedLightIn, class_1308 mob, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(mob);
        if (maid == null) {
            return;
        }
        class_1799 stack = maid.getBackpackShowItem();
        if (stack.method_7909() instanceof class_1746 bannerItem) {
            if (!renderer.getMainInfo().isShowBackpack() || mob.method_6113() || mob.method_5767()) {
                return;
            }
            if (maid instanceof EntityMaid entityMaid && !entityMaid.getConfigManager().isShowBackItem()) {
                return;
            }
            matrixStack.method_22903();
            matrixStack.method_22904(0, 0.5, 0.025);
            matrixStack.method_22905(0.5F, 0.5F, 0.5F);
            matrixStack.method_22907(class_7833.field_40713.rotationDegrees(5));
            class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578(TEXTURE));
            bannerModel.method_2828(matrixStack, buffer, packedLightIn, class_4608.field_21444, 1.0F, 1.0F, 1.0F, 1.0F);
            List<Pair<class_6880<class_2582>, class_1767>> list = class_2573.method_24280(bannerItem.method_7706(), class_2573.method_24281(stack));
            renderPatterns(matrixStack, bufferIn, packedLightIn, bannerModel.getPart("banner"), list);
            matrixStack.method_22909();
        }
    }


    private void renderPatterns(class_4587 poseStack, class_4597 bufferSource, int packedLight,
                                BedrockPart banner, List<Pair<class_6880<class_2582>, class_1767>> patterns) {
        banner.render(poseStack, class_1088.field_20847.method_30001(bufferSource, class_1921::method_23572, false),
                packedLight, class_4608.field_21444);
        for (int index = 0; index < 17 && index < patterns.size(); ++index) {
            Pair<class_6880<class_2582>, class_1767> patternPair = patterns.get(index);
            float[] colorComponents = patternPair.getSecond().method_7787();
            patternPair.getFirst().method_40230().map(class_4722::method_33081).ifPresent(
                    material -> banner.render(poseStack, material.method_24145(bufferSource, class_1921::method_23588),
                            packedLight, class_4608.field_21444, colorComponents[0], colorComponents[1], colorComponents[2],
                            1.0F));
        }
    }
}