package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.compat.simplehats.SimpleHatsCompat;
import com.mojang.authlib.GameProfile;
import io.github.fabricators_of_create.porting_lib.common.util.IPlantable;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_836;
import java.util.Map;

public class LayerMaidBipedHead extends class_3887<class_1308, BedrockModel<class_1308>> {
    private static final String SKULL_OWNER_TAG = "SkullOwner";
    private final EntityMaidRenderer maidRenderer;
    private final Map<class_2484.class_2485, class_5598> skullModels;

    public LayerMaidBipedHead(EntityMaidRenderer maidRenderer, class_5599 modelSet) {
        super(maidRenderer);
        this.maidRenderer = maidRenderer;
        this.skullModels = class_836.method_32160(modelSet);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_1308 mob, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean allowRenderHead = maidRenderer.getMainInfo().isShowCustomHead() && method_17165().hasHead();
        if (!allowRenderHead) {
            return;
        }

        // 渲染头盔栏的
        class_1799 head = mob.method_6118(class_1304.field_6169);
        if (!head.method_7960()) {
            class_1792 item = head.method_7909();
            poseStack.method_22903();
            this.method_17165().getHead().translateAndRotate(poseStack);
            if (item instanceof class_1747 && ((class_1747) item).method_7711() instanceof class_2190 skullBlock) {
                poseStack.method_22905(1.1875F, -1.1875F, -1.1875F);
                GameProfile gameprofile = getSkullGameProfile(head);
                poseStack.method_22904(-0.5D, 0.0D, -0.5D);
                class_2484.class_2485 type = skullBlock.method_9327();
                class_5598 modelBase = this.skullModels.get(type);
                class_1921 rendertype = class_836.method_3578(type, gameprofile);
                class_836.method_32161(null, 180.0F, 0.0F, poseStack, bufferIn, packedLightIn, modelBase, rendertype);
            }
            poseStack.method_22909();
        }

        IMaid maid = IMaid.convert(mob);
        if (maid == null) {
            return;
        }

        // 渲染女仆背部的
        class_1799 stack = maid.getBackpackShowItem();
        // 不做限制，任意方块都可以显示
        if (stack.method_7909() instanceof class_1747 blockItem) {
            class_2248 block = blockItem.method_7711();
            class_2680 blockState;
            if (block instanceof IPlantable iPlantable && !(block instanceof class_2320)) {
                blockState = iPlantable.getPlant(mob.method_37908(), mob.method_24515());
            } else {
                blockState = block.method_9564();
            }
            poseStack.method_22903();
            this.method_17165().getHead().translateAndRotate(poseStack);
            poseStack.method_22905(0.8F, -0.8F, -0.8F);
            poseStack.method_22904(-0.5, 0.625, -0.5);
            class_310.method_1551().method_1541().method_3353(blockState, poseStack, bufferIn, packedLightIn, class_4608.field_21444);
            poseStack.method_22909();
        } else {
            SimpleHatsCompat.renderHat(poseStack, bufferIn, packedLightIn, mob, stack, this.method_17165());
        }
    }

    @Nullable
    private GameProfile getSkullGameProfile(class_1799 head) {
        if (head.method_7985()) {
            class_2487 nbt = head.method_7969();
            if (nbt != null && nbt.method_10573(SKULL_OWNER_TAG, class_2520.field_33260)) {
                return class_2512.method_10683(nbt.method_10562(SKULL_OWNER_TAG));
            }
        }
        return null;
    }
}