package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class CacheIconTexture extends class_1044 {
    private final class_2960 modelId;
    private class_1011 imageIn;

    public CacheIconTexture(class_2960 modelId, class_1011 imageIn) {
        this.modelId = modelId;
        this.imageIn = imageIn;
    }

    @Override
    public void method_4625(class_3300 manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        if (imageIn == null) {
            return;
        }
        int width = imageIn.method_4307();
        int height = imageIn.method_4323();
        TextureUtil.prepareImage(this.method_4624(), 0, width, height);
        imageIn.method_22619(0, 0, 0, 0, 0, width, height, false, false, false, true);
        // 释放内存
        imageIn = null;
    }

    public class_2960 getModelId() {
        return modelId;
    }
}
