package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class FilePackTexture extends SizeTexture {
    private final class_2960 texturePath;
    private final Path rootPath;
    private int width = 16;
    private int height = 16;

    public FilePackTexture(Path rootPath, class_2960 texturePath) {
        this.rootPath = rootPath;
        this.texturePath = texturePath;
    }

    @Override
    public boolean isExist() {
        File textureFile = rootPath.resolve("assets").resolve(texturePath.method_12836()).resolve(texturePath.method_12832()).toFile();
        return textureFile.isFile();
    }

    @Override
    public void method_4625(class_3300 manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        File textureFile = rootPath.resolve("assets").resolve(texturePath.method_12836()).resolve(texturePath.method_12832()).toFile();
        if (textureFile.isFile()) {
            try (InputStream stream = Files.newInputStream(textureFile.toPath())) {
                class_1011 imageIn = class_1011.method_4309(stream);
                width = imageIn.method_4307();
                height = imageIn.method_4323();
                TextureUtil.prepareImage(this.method_4624(), 0, width, height);
                imageIn.method_22619(0, 0, 0, 0, 0, width, height, false, false, false, true);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getWidth() {
        return width;
    }

    @Override
    public int getHeight() {
        return height;
    }
}
