package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityShrine;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class TileEntityShrineRenderer implements class_827<TileEntityShrine> {
    private static final class_2960 TEXTURE = new class_2960(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/shrine.png");
    private final SimpleBedrockModel<class_1297> model;

    public TileEntityShrineRenderer(class_5614.class_5615 context) {
        model = BedrockModelLoader.getModel(BedrockModelLoader.SHRINE);
    }

    @Override
    public void render(TileEntityShrine shrine, float partialTick, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_2350 facing = shrine.method_11010().method_11654(BlockGomoku.FACING);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(180 - facing.method_10161() * 90));
        class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578(TEXTURE));
        model.method_2828(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0F, 1.0F, 1.0F, 1.0F);
        poseStack.method_22909();

        class_1937 level = shrine.method_10997();
        if (level == null) {
            return;
        }
        class_1799 stack = shrine.getStorageItem();
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.85, 0.5);
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        float deg = (level.method_8510() + partialTick) % 360;
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(deg));
        class_310.method_1551().method_1480().method_23178(stack, class_811.field_4318, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, level, 0);
        poseStack.method_22909();
    }
}