package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.builder;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import com.google.common.collect.Maps;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import java.util.Map;
import java.util.function.BiConsumer;

public class MaidBaubleBuilder {
    private final Map<class_1792, CustomKubeJSBauble> baubles = Maps.newHashMap();

    @Info("""
            Bind an item to a maid bauble. And specify a callback function that will be called every tick of the maid. <br>
            将物品与女仆饰品绑定。并且可以指定一个回调函数，在女仆每次 tick 时调用。
            """)
    public CustomKubeJSBauble bind(class_1792 item, @Nullable BiConsumer<EntityMaid, class_1799> onTick) {
        CustomKubeJSBauble bauble = new CustomKubeJSBauble(onTick);
        baubles.put(item, bauble);
        return bauble;
    }

    @Info("""
            Bind an item to a maid bauble. <br>
            将物品与女仆饰品绑定。
            """)
    public CustomKubeJSBauble bind(class_1792 item) {
        return bind(item, null);
    }

    @HideFromJS
    public void register(BaubleManager manager) {
        this.baubles.forEach(manager::bind);
        this.baubles.clear();
    }

    public static class CustomKubeJSBauble implements IMaidBauble {
        private final BiConsumer<EntityMaid, class_1799> biConsumer;

        public CustomKubeJSBauble(@Nullable BiConsumer<EntityMaid, class_1799> biConsumer) {
            this.biConsumer = biConsumer;
        }

        @Override
        public void onTick(EntityMaid maid, class_1799 baubleItem) {
            if (biConsumer != null) {
                biConsumer.accept(maid, baubleItem);
            }
        }
    }
}
