package com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class GunShootTargetTask extends class_4097<EntityMaid> {
    private int attackCooldown = -1;
    private int seeTime;

    public GunShootTargetTask() {
        super(ImmutableMap.of(class_4140.field_18446, class_4141.field_18458, class_4140.field_22355, class_4141.field_18456), 1200);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        Optional<class_1309> memory = owner.method_18868().method_18904(class_4140.field_22355);
        if (memory.isPresent()) {
            class_1309 target = memory.get();
            return IGun.mainhandHoldGun(owner) && owner.canSee(target);
        }
        return false;
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.method_18868().method_18896(class_4140.field_22355) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent((target) -> {
            // 实际上按照原版mc判定是看不见的，强行看见并朝向（没关就是开了？）
            owner.method_5988().method_20248(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = owner.canSee(target);
            boolean seeTimeMoreThanZero = this.seeTime > 0;

            // 如果两者不一致，重置看见时间
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            // 如果看见了对方，增加看见时间，否则减少
            if (canSee) {
                ++this.seeTime;
            } else {
                --this.seeTime;
            }

            // 如果实体手部处于激活状态
            if (--this.attackCooldown <= 0 && this.seeTime >= -60 && canSee) {
                class_1799 mainHandItem = owner.method_6047();
                IGun iGun = IGun.getIGunOrNull(mainHandItem);
                if (iGun == null) {
                    this.attackCooldown = 100;
                    return;
                }
                class_2960 gunId = iGun.getGunId(mainHandItem);
                TimelessAPI.getCommonGunIndex(gunId).ifPresentOrElse(index -> {
                    try {
                        // 由于部分枪包作者可能在写 lua 脚本时没有规范书写，导致 lua 脚本抛出异常
                        // 所以这里捕获异常，避免因为 lua 脚本错误导致游戏崩溃
                        this.performGunAttack(owner, target, mainHandItem, iGun, index);
                    } catch (Exception e) {
                        TouhouLittleMaid.LOGGER.error("Error while performing gun attack for EntityMaid: {}", owner.method_5667(), e);
                        // 如果发生异常，重置攻击冷却时间
                        this.attackCooldown = 100;
                    }
                }, () -> this.attackCooldown = 100);
            }
        });
    }

    public void performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem, IGun iGun, CommonGunIndex gunIndex) {
        GunData gunData = gunIndex.getGunData();

        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();

        float yaw = (float) -Math.toDegrees(Math.atan2(x, z));
        float pitch = (float) -Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z)));

        float radius = shooter.method_18413();

        IGunOperator gunOperator = IGunOperator.fromLivingEntity(shooter);
        ShootResult result = gunOperator.shoot(() -> pitch, () -> yaw);

        if (result == ShootResult.ID_NOT_EXIST || result == ShootResult.NOT_GUN) {
            this.attackCooldown = 100;
            return;
        }

        // 如果是狙击枪，应用瞄准
        String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
        if (gunIndex.getType().equals(sniper) && !gunOperator.getSynIsAiming()) {
            gunOperator.aim(true);
            // 多加 2 tick，用来平衡延迟
            this.attackCooldown = Math.round(gunData.getAimTime() * 20) + 2;
            return;
        }

        // 如果是非狙击枪，超出 radius 范围，那么也瞄准
        if (!gunIndex.getType().equals(sniper)) {
            float distance = shooter.method_5739(target);
            if (distance <= radius && gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
                // 多加 2 tick，用来平衡延迟
                this.attackCooldown = Math.round(gunData.getAimTime() * 20) + 2;
                return;
            }
            if (distance > radius && !gunOperator.getSynIsAiming()) {
                gunOperator.aim(true);
                // 多加 2 tick，用来平衡延迟
                this.attackCooldown = Math.round(gunData.getAimTime() * 20) + 2;
                return;
            }
        }

        if (result == ShootResult.NOT_DRAW) {
            gunOperator.draw(shooter::method_6047);
            // 多加 2 tick，用来平衡延迟
            this.attackCooldown = Math.round(gunData.getDrawTime() * 20) + 2;
            return;
        }

        if (result == ShootResult.NEED_BOLT) {
            gunOperator.bolt();
            this.attackCooldown = Math.round(gunData.getBoltActionTime() * 20) + 2;
            return;
        }

        if (result == ShootResult.NO_AMMO) {
            gunOperator.reload();
            float emptyTime = gunData.getReloadData().getCooldown().getEmptyTime();
            this.attackCooldown = Math.round(emptyTime * 20) + 2;
            return;
        }

        FireMode fireMode = iGun.getFireMode(gunItem);
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST) {
            this.attackCooldown = 10 + shooter.method_6051().method_43048(5);
            return;
        }

        this.attackCooldown = 2;
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        this.seeTime = 0;
        this.attackCooldown = -1;
        maid.setSwingingArms(false);
        // 停止瞄准
        this.stopAim(maid);
    }

    private void stopAim(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity(maid);
            if (gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
            }
        });
    }
}
