package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.RangedWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4174;
import net.minecraft.class_4215;
import net.minecraft.class_8;

/**
 * 女仆在水下，空气值不足时，会尝试吃任何可以补充空气的东西
 * 如果没有找到，则会尝试寻找可以呼吸的位置
 */
public class MaidBreathAirTask extends class_4097<EntityMaid> {
    private static final int MAX_PROBABILITY = 5;
    /**
     * 数值过大可能性能不流畅
     */
    private static final int AIR_SEARCH_RANGE = 16;

    public MaidBreathAirTask() {
        super(ImmutableMap.of());
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 level, EntityMaid maid) {
        // 正在食用可呼吸的食物
        if (maid.getSwimManager().isEatBreatheItem()) {
            return false;
        }
        // 如果正在上浮但是失去目标也是需要重新计算的。目标存在时可以不需要再次计算
        if (maid.getSwimManager().isGoingToBreath() && maid.method_18868().method_18896(class_4140.field_18445)) {
            class_2338 target = maid.method_18868().method_18904(class_4140.field_18445).get().method_19094().method_18989();
            // 有可能在途中被其他任务覆盖呼吸目标点，还是吸口气比较要紧
            if (givesAir(maid, target)) {
                // 不明原因出现的莫名其妙重寻路导致生成一条新的不可达路线
                if (!maid.method_5942().method_6357() || maid.method_24515().method_19455(target) <= 1) {
                    return false;
                }
            }
        }
        // 氧气值，默认最大是 300
        // 100 则意味着还有 5 秒呼吸时间
        if (maid.method_5669() >= 100) {
            return false;
        }
        // 拥有水下呼吸等效果
        if (class_1292.method_5574(maid)) {
            return false;
        }
        // 溺水保护饰品
        if (hasDrownBauble(maid)) {
            return false;
        }
        // 没有在正在食用物品
        return !maid.method_6115();
    }

    @Override
    protected void start(class_3218 level, EntityMaid maid, long gameTime) {
        if (this.eatBreatheItem(maid)) {
            return;
        }
        this.findAirPosition(level, maid);
    }

    private boolean hasDrownBauble(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        for (int i = 0; i < maidBauble.getSlots(); i++) {
            if (maidBauble.getStackInSlot(i).method_31574(InitItems.DROWN_PROTECT_BAUBLE)) {
                return true;
            }
        }
        return false;
    }

    private boolean eatBreatheItem(EntityMaid maid) {
        // 先查询手部的物品能否吃：能就直接开吃，否就进行后续工作
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemInHand = maid.method_5998(hand);
            if (itemInHand.method_7960()) {
                continue;
            }
            if (this.isBreatheFood(maid, itemInHand)) {
                this.startEatBreatheItem(maid, itemInHand, hand);
                return true;
            }
        }

        // 对手部进行处理：如果没有空的手部，那就取副手
        class_1268 eanHand = class_1268.field_5810;
        for (class_1268 hand : class_1268.values()) {
            if (maid.method_5998(hand).method_7960()) {
                eanHand = hand;
                break;
            }
        }
        class_1799 itemInHand = maid.method_5998(eanHand);

        // 尝试在背包中寻找食物放入
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpackInv.getSlots(); i++) {
            class_1799 stack = backpackInv.getStackInSlot(i);
            if (stack.method_7960()) {
                continue;
            }
            if (this.isBreatheFood(maid, stack)) {
                class_1799 foodStack = backpackInv.extractItem(i, backpackInv.getStackInSlot(i).method_7947(), false);
                class_1799 handStack = itemInHand.method_7972();
                maid.method_6122(eanHand, foodStack);
                maid.memoryHandItemStack(handStack);
                itemInHand = maid.method_5998(eanHand);
                hasFood = true;
                break;
            }
        }

        // 开吃
        if (hasFood) {
            this.startEatBreatheItem(maid, itemInHand, eanHand);
        }
        return hasFood;
    }

    private void startEatBreatheItem(EntityMaid maid, class_1799 stack, class_1268 hand) {
        maid.getSwimManager().setEatBreatheItem(true);

        //FoodProperties foodProperties = stack.getFoodProperties(maid);
        class_4174 foodProperties = stack.method_7909().method_19264();
        float total = 0;
        if (foodProperties != null) {
            int nutrition = foodProperties.method_19230();
            float saturationModifier = foodProperties.method_19231();
            total = nutrition + nutrition * saturationModifier * 2;
        }
        maid.method_6019(hand);

        // 原版的熟牛肉之类的一般在 20 左右（除了迷之炖菜为 34.2）
        if (maid.method_6051().method_43048(MAX_PROBABILITY) < total) {
            float healCount = Math.max(total / MAX_PROBABILITY, 1);
            maid.method_6025(healCount);
            NetworkHandler.sendToNearby(maid, SpawnParticleMessage.ID, SpawnParticleMessage.encode(maid.method_5628(), SpawnParticleMessage.Type.HEAL, stack.method_7935()));
        }
    }

    private boolean isBreatheFood(EntityMaid maid, class_1799 stack) {
        // 寻找药水
        if (stack.method_7909() instanceof class_1812) {
            List<class_1293> mobEffects = class_1844.method_8067(stack);
            if (mobEffects.isEmpty()) {
                return false;
            }
            for (class_1293 effect : mobEffects) {
                if (effect.method_5579() == class_1294.field_5923) {
                    return true;
                }
            }
            return false;
        }

        // 或者能提供水下呼吸的食物
        //FoodProperties foodProperties = stack.getFoodProperties(maid);
        class_4174 foodProperties = stack.method_7909().method_19264();
        if (foodProperties == null) {
            return false;
        }
        List<Pair<class_1293, Float>> effects = foodProperties.method_19235();
        if (effects.isEmpty()) {
            return false;
        }
        for (Pair<class_1293, Float> effect : effects) {
            if (effect.getFirst().method_5579() == class_1294.field_5923) {
                return true;
            }
        }
        return false;
    }


    // 寻找可呼吸新鲜空气的地方
    private void findAirPosition(class_3218 level, EntityMaid maid) {
        if (!maid.canBrainMoving()) {
            return;
        }

        class_8 nodeEvaluator = maid.method_5942().method_6342();
        var pathFinding = new MaidPathFindingBFS(nodeEvaluator, level, maid, AIR_SEARCH_RANGE, AIR_SEARCH_RANGE);
        Optional<class_2338> match = pathFinding.find(blockPos -> this.givesAir(maid, blockPos));
        pathFinding.finish();

        // FIXME: BFS 算法找到的目标点在 A* 算法中可能会需要更多步骤才能走到，当超过了寻路长度后可能会被截断导致无法找到路径
        if (match.isPresent() && maid.canPathReach(match.get())) {
            maid.getSwimManager().setGoingToBreath(true);
            class_4215.method_24561(maid, match.get(), 0.5f, 1);
            return;
        }

        // 当前女仆坐标的海平面位置
        class_2338.class_2339 seaLevelPos = maid.method_24515().method_25503().method_33098(level.method_8615() + 1);
        if (this.givesAir(maid, seaLevelPos) && maid.canPathReach(seaLevelPos)) {
            maid.getSwimManager().setGoingToBreath(true);
            class_4215.method_24561(maid, seaLevelPos, 0.5f, 1);
            return;
        }

        // 当前女仆坐标的海平面 5x5x1 区域
        final int seaLevelOffset = 2;
        Iterable<class_2338> canBreathPos = class_2338.method_10094(
                seaLevelPos.method_10263() - seaLevelOffset,
                seaLevelPos.method_10264(),
                seaLevelPos.method_10260() - seaLevelOffset,
                seaLevelPos.method_10263() + seaLevelOffset,
                seaLevelPos.method_10264(),
                seaLevelPos.method_10260() + seaLevelOffset);
        for (class_2338 canBreathPo : canBreathPos) {
            if (this.givesAir(maid, canBreathPo) && maid.canPathReach(canBreathPo)) {
                maid.getSwimManager().setGoingToBreath(true);
                class_4215.method_24561(maid, canBreathPo, 0.5f, 1);
                return;
            }
        }
    }

    // 提供空气的判断
    // 反正女仆也钻不进一格的高度（寻路困难），直接判断两格的空气，避免寻路判断发生的故障
    private boolean givesAir(EntityMaid maid, class_2338 pos) {
        class_1937 level = maid.field_6002;
        class_2680 blockState = level.method_8320(pos);
        boolean noFluid = level.method_8316(pos).method_15769() || blockState.method_27852(class_2246.field_10422);
        return noFluid && blockState.method_26220(level, pos).method_1110();
    }
}
