package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.IPlayerMixin;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.EntityAccessor;
import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidFollowOwnerVehicleTask extends class_4097<EntityMaid> {
    private static final int RANGE = 3;
    private final float speedModifier;
    private final int stopDistance;
    private class_1297 ownerControlledVehicle;
    private Type type = Type.NONE;

    public MaidFollowOwnerVehicleTask(float speedModifier, int stopDistance) {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18458));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid maid) {
        // 必须是跟随模式并且自身可以移动
        if (!this.maidStateConditions(maid)) {
            return false;
        }

        // 主人必须在场
        class_1309 owner = maid.method_35057();
        if (!this.ownerStateConditions(owner) || !(owner instanceof class_1657 player)) {
            return false;
        }

        class_1297 ownerControlledVehicle = owner.method_49694();
        class_1297 maidVehicle = maid.method_5854();

        // 如果主人下船（载具）了，女仆也下船。反之上船了，女仆也跟着上船
        // 当然，这个载具必须还有空位才可以
        if (ownerControlledVehicle == null) {
            // 玩家下船有大约 60 tick 冷却时间，在此时间内，一定范围内的女仆才能主动下船，避免误伤
            boolean isCooldown = ((IPlayerMixin) player).tlmInRemoveVehicleCooldown();
            boolean maidInDismountRange = maid.method_5739(owner) < RANGE;
            if (maid.method_5765() && isCooldown && maidInDismountRange) {
                this.type = Type.STOP;
                return true;
            }
            return false;
        }

        // 玩家和女仆同坐一艘船，不需要判断
        if (maidVehicle != null && maidVehicle == ownerControlledVehicle) {
            return false;
        }

        // 乘坐的载具不能添加新的乘客了，不执行
        if (!((EntityAccessor) ownerControlledVehicle).tlmCanAddPassenger(maid)) {
            return false;
        }

        // 女仆开始尝试骑乘载具
        if (maid.method_24516(ownerControlledVehicle, RANGE)) {
            this.ownerControlledVehicle = ownerControlledVehicle;
            this.type = Type.RIDE;
            return true;
        } else if (!maid.method_18868().method_18896(class_4140.field_18445)) {
            class_4215.method_24557(maid, ownerControlledVehicle, speedModifier, stopDistance);
            return false;
        }

        return false;
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        switch (this.type) {
            case RIDE -> Optional.ofNullable(this.ownerControlledVehicle).ifPresent(maid::method_5804);
            case STOP -> maid.method_5848();
        }
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        this.ownerControlledVehicle = null;
        this.type = Type.NONE;
    }

    private boolean canBrainMoving(EntityMaid maid) {
        // 不需要判断是否女仆正在骑乘
        return !maid.isMaidInSittingPose() && !maid.method_6113() && !maid.method_5934();
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && this.canBrainMoving(maid) && maid.isRideable();
    }

    private boolean ownerStateConditions(@Nullable class_1309 owner) {
        return owner != null && owner.method_5805() && !owner.method_7325() && !owner.method_29504();
    }

    enum Type {
        RIDE,
        STOP,
        NONE;
    }
}