package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class MaidTridentTargetTask extends class_4097<EntityMaid> {
    /**
     * 一秒的间隔使用时间，模拟忠诚后的三叉戟击中目标返回来所需要的时间，不然就太 IMBA 了...
     */
    private final int attackCooldown = 20;
    private int attackTime = -1;
    private int seeTime;

    public MaidTridentTargetTask() {
        super(ImmutableMap.of(class_4140.field_18446, class_4141.field_18458,
                class_4140.field_22355, class_4141.field_18456), 1200);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        Optional<class_1309> memory = owner.method_18868().method_18904(class_4140.field_22355);
        if (memory.isPresent()) {
            class_1309 target = memory.get();
            return hasTrident(owner) && owner.canSee(target);
        }
        return false;
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.method_18868().method_18896(class_4140.field_22355) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent((target) -> {
            // 强行看见并朝向
            owner.method_5988().method_20248(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = owner.canSee(target);
            boolean seeTimeMoreThanZero = this.seeTime > 0;

            // 如果两者不一致，重置看见时间
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            // 如果看见了对方，增加看见时间，否则减少
            if (canSee) {
                ++this.seeTime;
            } else {
                --this.seeTime;
            }

            // 如果实体手部处于激活状态
            if (owner.method_6115()) {
                // 如果看不见对方超时 60，重置激活状态
                if (!canSee && this.seeTime < -60) {
                    owner.method_6021();
                } else if (canSee) {
                    // 否则开始进行远程攻击
                    int ticksUsingItem = owner.method_6048();

                    // 物品最大使用计数大于 30 才可以
                    // 如果有引雷，必须 6 格之外（安全范围，以免波及自身）
                    boolean hasChanneling = class_1890.method_8228(owner.method_6047());
                    boolean canUseChanneling = owner.field_6002.method_8546() && !owner.method_5869() && hasChanneling;
                    boolean tooClose = owner.method_24516(target, 6);
                    // 引雷附魔在生物处于雷雨处且不在水中时会触发，需要保证安全距离
                    boolean inSafeArea = !(canUseChanneling && tooClose);
                    if (ticksUsingItem >= 30 && inSafeArea) {
                        owner.method_6021();
                        owner.method_7105(target, 0);
                        this.attackTime = this.attackCooldown;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                // 非激活状态，但是时长合适，开始激活手部
                owner.method_6019(class_1268.field_5808);
            }
        });
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeTime = 0;
        this.attackTime = -1;
        entityIn.method_6021();
    }

    private boolean hasTrident(EntityMaid maid) {
        return maid.method_6047().method_7909() instanceof class_1835;
    }
}
