package com.github.tartaricacid.touhoulittlemaid.entity.ai.control;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1335;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

/**
 * 参考：net.minecraft.world.entity.monster.Drowned.DrownedMoveControl
 */
public class MaidMoveControl extends class_1335 {
    private final EntityMaid maid;

    public MaidMoveControl(EntityMaid maid) {
        super(maid);
        this.maid = maid;
    }

    @Override
    public void method_6240() {
        // 如何女仆想游泳了
        if (this.maid.getSwimManager().wantToSwim()) {
            if (this.maid.method_5869() && this.maid.method_5942().method_6357()) {
                this.maid.method_6125(0.0F);
                return;
            }

            double x = this.field_6370 - this.maid.method_23317();
            double y = this.field_6369 - this.maid.method_23318();
            double z = this.field_6367 - this.maid.method_23321();
            double sqrt = Math.sqrt(x * x + y * y + z * z);
            float yRot = (float) (Math.toDegrees(class_3532.method_15349(z, x)) - 90);

            this.maid.method_36456(this.method_6238(this.maid.method_36454(), yRot, 90.0F));
            this.maid.field_6283 = this.maid.method_36454();
            float speed = (float) (this.field_6372 * this.maid.method_26825(class_5134.field_23719));
            float speedLerp = class_3532.method_16439(1, this.maid.method_6029(), speed);

            if (maid.getSwimManager().getSwimTarget() != null) {
                maid.method_5988().method_19615(maid.getSwimManager().getSwimTarget().method_46558());
            }

            // 太慢了，3 倍基础速度
            this.maid.method_6125(speedLerp * 3);
            this.maid.method_18799(this.maid.method_18798().method_1031(speedLerp * x * 0.005, speedLerp * y / sqrt * 0.25, speedLerp * z * 0.005));
        } else {
            // 部分 Climbable 会被识别成实体方块并尝试跳一跳，这会导致女仆无法通过这些位置。将其 jump 去除
            if (this.field_6374 == class_1336.field_6378) {
                this.field_6374 = class_1336.field_6377;

                double x = this.field_6370 - this.field_6371.method_23317();
                double y = this.field_6369 - this.field_6371.method_23318();
                double z = this.field_6367 - this.field_6371.method_23321();
                double sqrt = x * x + y * y + z * z;
                if (sqrt < 2.5e-7) {
                    this.field_6371.method_5930(0);
                    return;
                }

                float angle = class_3532.field_29848 * (float) class_3532.method_15349(z, x) - 90;
                this.field_6371.method_36456(this.method_6238(this.field_6371.method_36454(), angle, 90));
                this.field_6371.method_6125((float) (this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));

                class_2338 blockPos = this.field_6371.method_24515();
                class_2680 blockState = this.field_6371.field_6002.method_8320(blockPos);
                class_265 voxelShape = blockState.method_26220(this.field_6371.method_37908(), blockPos);

                if (this.field_6371.method_49476() < y && x * x + z * z < Math.max(1, this.field_6371.method_17681())
                        || !voxelShape.method_1110()
                        && this.field_6371.method_23318() < (voxelShape.method_1105(class_2350.class_2351.field_11052) + blockPos.method_10264())
                        && !blockState.method_26164(TagBlock.MAID_JUMP_FORBIDDEN_BLOCK)
                ) {
                    this.field_6371.method_5993().method_6233();
                    this.field_6374 = class_1336.field_6379;
                }
            } else if (this.field_6374 == class_1336.field_6379 && this.field_6371.method_5799()) {
                this.field_6374 = class_1336.field_6377;
            } else {
                super.method_6240();
            }
        }
    }
}