package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.InvWrapper;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.TankBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.item.BackpackLevel;
import com.github.tartaricacid.touhoulittlemaid.item.ItemTankBackpack;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncFluidAmountMessage;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4587;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import javax.annotation.Nullable;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.TANK_BACKPACK;

public class TankBackpack extends IMaidBackpack {
    public static final class_2960 ID = new class_2960(TouhouLittleMaid.MOD_ID, "tank");

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_1792 getItem() {
        return InitItems.TANK_BACKPACK;
    }

    @Override
    public void onPutOn(class_1799 stack, class_1657 player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData tankBackpackData) {
            ItemTankBackpack.setTankBackpack(maid, tankBackpackData, stack);
        }
    }

    @Override
    public void onTakeOff(class_1799 stack, class_1657 player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData tankBackpackData) {
            InvWrapper inv = new InvWrapper(tankBackpackData);
            ItemsUtil.dropEntityItems(maid, inv);
        }
        dropRelativeItems(stack, maid);
    }

    @Override
    public class_1799 getTakeOffItemStack(class_1799 stack, @Nullable class_1657 player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData tankBackpackData) {
            return ItemTankBackpack.getTankBackpack(tankBackpackData);
        }
        return super.getTakeOffItemStack(stack, player, maid);
    }

    @Override
    public void onSpawnTombstone(EntityMaid maid, EntityTombstone tombstone) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData tankBackpackData) {
            InvWrapper inv = new InvWrapper(tankBackpackData);
            for (int i = 0; i < inv.getSlots(); i++) {
                int size = inv.getSlotLimit(i);
                tombstone.insertItem(inv.extractItem(i, size, false));
            }
        }
    }

    @Override
    public boolean hasBackpackData() {
        return true;
    }

    @Nullable
    @Override
    public IBackpackData getBackpackData(EntityMaid maid) {
        return new TankBackpackData(maid);
    }

    @Override
    public class_3908 getGuiProvider(int entityId) {
        return new ExtendedScreenHandlerFactory() {
            @Override
            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(entityId);
            }

            @Override
            public class_2561 method_5476() {
                return class_2561.method_43470("Maid Tank Container");
            }

            @Override
            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                // 打开GUI时发包同步客户端流体amount
                if (player instanceof class_3222 serverPlayer && player.field_6002.method_8469(entityId) instanceof EntityMaid maid) {
                    IBackpackData backpackData = maid.getBackpackData();
                    if (backpackData instanceof TankBackpackData tankBackpackData) {
                        ServerPlayNetworking.send(serverPlayer, SyncFluidAmountMessage.ID, SyncFluidAmountMessage.encode(entityId, (int) tankBackpackData.getTank().amount));
                    }
                }
                return new TankBackpackContainer(index, playerInventory, entityId);
            }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

/*            @Override
            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }*/
        };
    }

    @Override
    public int getAvailableMaxContainerIndex() {
        return BackpackLevel.TANK_CAPACITY;
    }

    @Nullable
    @Override
    @Environment(EnvType.CLIENT)
    public class_583<EntityMaid> getBackpackModel(class_5599 modelSet) {
        return BedrockModelLoader.getModel(TANK_BACKPACK);
    }

    @Nullable
    @Override
    @Environment(EnvType.CLIENT)
    public class_2960 getBackpackTexture() {
        return new class_2960(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/backpack/tank_backpack.png");
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void offsetBackpackItem(class_4587 poseStack) {
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-7.5F));
        poseStack.method_22904(0, 0.625, -0.25);
    }
}
