package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement.WaitingChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class WaitingChatBubbleData implements IChatBubbleData {
    public static final class_2960 ID = new class_2960(TouhouLittleMaid.MOD_ID, "waiting");

    private final int existTick;
    private final class_2960 bg;
    private final int priority;
    private final class_2561 text;
    private final class_2960 icon;

    @Environment(EnvType.CLIENT)
    private IChatBubbleRenderer renderer;

    private WaitingChatBubbleData(int existTick, class_2960 bg, int priority, class_2561 text, class_2960 icon) {
        this.existTick = existTick;
        this.bg = bg;
        this.priority = priority;
        this.text = text;
        this.icon = icon;
    }

    public static WaitingChatBubbleData create(int existTick, class_2960 bg, int priority, class_2561 text, class_2960 icon) {
        return new WaitingChatBubbleData(existTick, bg, priority, text, icon);
    }

    public static WaitingChatBubbleData create(class_2561 text, class_2960 icon) {
        return new WaitingChatBubbleData(DEFAULT_EXIST_TICK, TYPE_2, DEFAULT_PRIORITY, text, icon);
    }

    @Override
    public int existTick() {
        return this.existTick;
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (renderer == null) {
            renderer = new WaitingChatBubbleRenderer(this.bg, this.text, this.icon);
        }
        return renderer;
    }

    public static class WaitingChatSerializer implements IChatBubbleData.ChatSerializer {
        @Override
        public IChatBubbleData readFromBuff(class_2540 buf) {
            // 往客户端同步的数据里，不需要同步 existTick 和 priority，这两个数据仅在服务端有效
            return new WaitingChatBubbleData(DEFAULT_EXIST_TICK, buf.method_10810(), DEFAULT_PRIORITY, buf.method_10808(), buf.method_10810());
        }

        @Override
        public void writeToBuff(class_2540 buf, IChatBubbleData data) {
            WaitingChatBubbleData textChat = (WaitingChatBubbleData) data;
            buf.method_10812(textChat.bg);
            buf.method_10805(textChat.text);
            buf.method_10812(textChat.icon);
        }
    }
}
