package com.github.tartaricacid.touhoulittlemaid.entity.item;

import cn.sh1rocu.touhoulittlemaid.api.extension.IEntityAdditionalSpawnData;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_4168;
import net.minecraft.world.entity.*;
import org.apache.commons.lang3.StringUtils;

public class EntitySit extends class_1297 {
    public static final class_1299<EntitySit> TYPE = class_1299.class_1300.<EntitySit>method_5903(EntitySit::new, class_1311.field_17715)
            .method_17687(0.5f, 0.1f)
            .method_27299(10)
            .method_5905("sit");
    private static final class_2940<String> SIT_TYPE = class_2945.method_12791(EntitySit.class, class_2943.field_13326);
    private int passengerTick = 0;
    private class_2338 associatedBlockPos = class_2338.field_10980;

    public EntitySit(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntitySit(class_1937 worldIn, class_243 pos, String joyType, class_2338 associatedBlockPos) {
        this(TYPE, worldIn);
        this.method_33574(pos);
        this.setJoyType(joyType);
        this.associatedBlockPos = associatedBlockPos;
    }

    @Override
    public double method_5621() {
        return -0.25;
    }

    @Override
    protected void method_5693() {
        this.field_6011.method_12784(SIT_TYPE, "");
    }

    @Override
    protected void method_5749(class_2487 tag) {
        if (tag.method_10573("SitJoyType", class_2520.field_33258)) {
            this.setJoyType(tag.method_10558("SitJoyType"));
        }
        if (tag.method_10573("AssociatedBlockPos", class_2520.field_33260)) {
            this.associatedBlockPos = class_2512.method_10691(tag.method_10562("AssociatedBlockPos"));
        }
    }

    @Override
    protected void method_5652(class_2487 tag) {
        if (StringUtils.isNotBlank(this.getJoyType())) {
            tag.method_10582("SitJoyType", this.getJoyType());
        }
        tag.method_10566("AssociatedBlockPos", class_2512.method_10692(this.associatedBlockPos));
    }

    @Override
    public void method_5773() {
        if (!this.field_6002.field_9236) {
            this.method_31473();
            this.checkPassengers();
            if (this.method_31483() instanceof EntityMaid maid) {
                this.tickMaid(maid);
            }
        }
    }

    private void tickMaid(EntityMaid maid) {
        maid.method_36456(this.method_36454());
        maid.method_5847(this.method_36454());
        if (field_6012 % 20 == 0) {
            FavorabilityManager manager = maid.getFavorabilityManager();
            String joyType = this.getJoyType();
            IMaidTask task = maid.getTask();

            // 给予好感度提升
            manager.apply(joyType);
            // 如果是空闲状态，那么娱乐方块可以随便坐
            if (this.isIdleSchedule(maid)) {
                return;
            }
            // 如果是工作状态，看看这个工作是否允许你坐在上面
            if (this.isWorkSchedule(maid) && task.canSitInJoy(maid, joyType)) {
                return;
            }
            // 否则，不允许在上面待着
            maid.method_5848();
        }
    }

    private void checkPassengers() {
        if (this.method_5685().isEmpty()) {
            passengerTick++;
        } else {
            passengerTick = 0;
        }
        if (passengerTick > 10) {
            this.method_31472();
        }
    }

    private boolean isIdleSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == class_4168.field_18595;
    }

    private boolean isWorkSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == class_4168.field_18596;
    }

    public class_2338 getAssociatedBlockPos() {
        return associatedBlockPos;
    }

    @Override
    public boolean method_5698(class_1297 pEntity) {
        return true;
    }

    @Override
    public boolean method_5643(class_1282 pSource, float pAmount) {
        return false;
    }

    @Override
    public void method_5784(class_1313 pType, class_243 pPos) {
    }

    @Override
    public void method_5697(class_1297 entity) {
    }

    @Override
    public void method_5762(double pX, double pY, double pZ) {
    }

    @Override
    protected boolean method_5638() {
        return false;
    }

    @Override
    public void method_5800(class_3218 pLevel, class_1538 pLightning) {
    }

    @Override
    public void method_18382() {
    }

    @Override
    public boolean method_30949(class_1297 entity) {
        return false;
    }

    @Override
    public class_2596<class_2602> method_18002() {
        return IEntityAdditionalSpawnData.getEntitySpawningPacket(this);
    }

    public String getJoyType() {
        return this.field_6011.method_12789(SIT_TYPE);
    }

    public void setJoyType(String type) {
        this.field_6011.method_12778(SIT_TYPE, type);
    }
}
