package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.ContextBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.*;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5498;

public class QueryBinding extends ContextBinding {
    public static final QueryBinding INSTANCE = new QueryBinding();

    @SuppressWarnings("resource")
    private QueryBinding() {
        function("biome_has_all_tags", new BiomeHasAllTags());
        function("biome_has_any_tag", new BiomeHasAnyTag());
        function("relative_block_has_all_tags", new RelativeBlockHasAllTags());
        function("relative_block_has_any_tag", new RelativeBlockHasAnyTag());
        function("is_item_name_any", new ItemNameAny());
        function("equipped_item_all_tags", new EquippedItemAllTags());
        function("equipped_item_any_tag", new EquippedItemAnyTags());
        function("position", new Position());
        function("position_delta", new PositionDelta());

        function("max_durability", new ItemMaxDurability());
        function("remaining_durability", new ItemRemainingDurability());

        var("actor_count", ctx -> ctx.level().method_18120());
        var("anim_time", ctx -> ctx.animationControllerContext().animTime());
        var("life_time", ctx -> ctx.geoInstance().getSeekTime() / 20.0);
        var("head_x_rotation", ctx -> ctx.data().netHeadYaw);
        var("head_y_rotation", ctx -> ctx.data().headPitch);
        var("moon_phase", ctx -> ctx.level().method_30273());
        var("time_of_day", ctx -> MolangUtils.normalizeTime(ctx.level().method_8532()));
        var("time_stamp", ctx -> ctx.level().method_8532());

        entityVar("yaw_speed", ctx -> getYawSpeed(ctx.entity()));
        entityVar("cardinal_facing_2d", ctx -> ctx.entity().method_5735().method_10146());
        entityVar("distance_from_camera", ctx -> ctx.mc().field_1773.method_19418().method_19326().method_1022(ctx.entity().method_19538()));
        entityVar("eye_target_x_rotation", ctx -> ctx.entity().method_5695(ctx.animationEvent().getPartialTick()));
        entityVar("eye_target_y_rotation", ctx -> ctx.entity().method_5705(ctx.animationEvent().getPartialTick()));
        entityVar("ground_speed", ctx -> getGroundSpeed(ctx.entity()));
        entityVar("modified_distance_moved", ctx -> ctx.entity().field_5973);
        entityVar("vertical_speed", ctx -> getVerticalSpeed(ctx.entity()));
        entityVar("walk_distance", ctx -> ctx.entity().field_5994);
        entityVar("has_rider", ctx -> ctx.entity().method_5782());
        entityVar("is_first_person", ctx -> ctx.mc().field_1690.method_31044() == class_5498.field_26664);
        entityVar("is_in_water", ctx -> ctx.entity().method_5799());
        entityVar("is_in_water_or_rain", ctx -> ctx.entity().method_5637());
        entityVar("is_on_fire", ctx -> ctx.entity().method_5809());
        entityVar("is_on_ground", ctx -> ctx.entity().method_24828());
        entityVar("is_riding", ctx -> ctx.entity().method_5765());
        entityVar("is_sneaking", ctx -> ctx.entity().method_24828() && ctx.entity().method_18376() == class_4050.field_18081);
        entityVar("is_spectator", ctx -> ctx.entity().method_7325());
        entityVar("is_sprinting", ctx -> ctx.entity().method_5624());
        entityVar("is_swimming", ctx -> ctx.entity().method_5681());

        livingEntityVar("body_x_rotation", ctx -> class_3532.method_16439(ctx.animationEvent().getPartialTick(), ctx.entity().field_6004, ctx.entity().method_36455()));
        livingEntityVar("body_y_rotation", ctx -> class_3532.method_15393(class_3532.method_16439(ctx.animationEvent().getPartialTick(), ctx.entity().field_6220, ctx.entity().field_6283)));
        livingEntityVar("health", ctx -> ctx.entity().method_6032());
        livingEntityVar("max_health", ctx -> ctx.entity().method_6063());
        livingEntityVar("hurt_time", ctx -> ctx.entity().field_6235);
        livingEntityVar("is_eating", ctx -> ctx.entity().method_6030().method_7976() == class_1839.field_8950);
        livingEntityVar("is_playing_dead", ctx -> ctx.entity().method_29504());
        livingEntityVar("is_sleeping", ctx -> ctx.entity().method_6113());
        livingEntityVar("is_using_item", ctx -> ctx.entity().method_6115());
        livingEntityVar("item_in_use_duration", ctx -> ctx.entity().method_6048() / 20.0);
        livingEntityVar("item_max_use_duration", ctx -> getMaxUseDuration(ctx.entity()) / 20.0);
        livingEntityVar("item_remaining_use_duration", ctx -> ctx.entity().method_6014() / 20.0);
        livingEntityVar("equipment_count", ctx -> getEquipmentCount(ctx.entity()));

        // 为了兼容 ysm 添加的变量
        function("debug_output", new EmptyFunction());
        var("has_cape", ctx -> false);
        var("cape_flap_amount", ctx -> 0);
        maidEntityVar("player_level", ctx -> ctx.entity().getExperience());
        mobEntityVar("is_jumping", ctx -> !ctx.entity().method_5765() && !ctx.entity().method_24828() && !ctx.entity().method_5799());
    }


    private static int getEquipmentCount(class_1309 entity) {
        int count = 0;
        for (var slot : class_1304.values()) {
            if (!slot.method_46643()) {
                continue;
            }
            var stack = EquipmentUtil.getEquippedItem(entity, slot);
            if (!stack.method_7960()) {
                count++;
            }
        }
        return count;
    }

    private static double getMaxUseDuration(class_1309 player) {
        class_1799 useItem = player.method_6030();
        if (useItem.method_7960()) {
            return 0.0;
        } else {
            return useItem.method_7935();
        }
    }

    private static float getYawSpeed(class_1297 entity) {
        return 20 * (entity.method_36454() - entity.field_5982);
    }

    private static float getGroundSpeed(class_1297 player) {
        class_243 velocity = player.method_18798();
        return 20 * class_3532.method_15355((float) ((velocity.field_1352 * velocity.field_1352) + (velocity.field_1350 * velocity.field_1350)));
    }

    private static float getVerticalSpeed(class_1297 entity) {
        return 20 * (float) (entity.method_19538().field_1351 - entity.field_6036);
    }
}
