package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4168;
import java.util.List;

public class ItemKappaCompass extends class_1792 {
    public ItemKappaCompass() {
        super((new class_1792.class_1793()).method_7889(1));
    }

    public static void addPoint(class_4168 activity, class_2338 pos, class_1799 compass) {
        class_2487 tag = compass.method_7911("KappaCompassData");
        tag.method_10566(activity.method_19634(), class_2512.method_10692(pos));
    }

    public static void addDimension(class_2960 dimension, class_1799 compass) {
        class_2487 tag = compass.method_7911("KappaCompassData");
        tag.method_10582("Dimension", dimension.toString());
    }

    @Nullable
    public static class_2338 getPoint(class_4168 activity, class_1799 compass) {
        class_2487 tag = compass.method_7941("KappaCompassData");
        if (tag != null) {
            String name = activity.method_19634();
            if (tag.method_10573(name, class_2520.field_33260)) {
                return class_2512.method_10691(tag.method_10562(name));
            }
            name = class_4168.field_18595.method_19634();
            if (tag.method_10573(name, class_2520.field_33260)) {
                return class_2512.method_10691(tag.method_10562(name));
            }
            name = class_4168.field_18596.method_19634();
            if (tag.method_10573(name, class_2520.field_33260)) {
                return class_2512.method_10691(tag.method_10562(name));
            }
        }
        return null;
    }

    @Nullable
    public static class_2960 getDimension(class_1799 compass) {
        class_2487 tag = compass.method_7941("KappaCompassData");
        if (tag != null) {
            return new class_2960(tag.method_10558("Dimension"));
        }
        return null;
    }

    public static int getRecordCount(class_1799 compass) {
        class_2487 tag = compass.method_7941("KappaCompassData");
        int count = 0;
        if (tag != null) {
            if (tag.method_10573(class_4168.field_18596.method_19634(), class_2520.field_33260)) {
                count++;
            }
            if (tag.method_10573(class_4168.field_18595.method_19634(), class_2520.field_33260)) {
                count++;
            }
            if (tag.method_10573(class_4168.field_18597.method_19634(), class_2520.field_33260)) {
                count++;
            }
        }
        return count;
    }

    public static boolean hasKappaCompassData(class_1799 compass) {
        return compass.method_7941("KappaCompassData") != null;
    }

    @Override
    public class_1269 method_7847(class_1799 compass, class_1657 player, class_1309 livingEntity, class_1268 hand) {
        if (livingEntity instanceof EntityMaid maid && !maid.field_6002.field_9236) {
            if (player.method_21751()) {
                maid.getSchedulePos().clear(maid);
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.maid_clear"));
                player.field_6002.method_8396(null, player.method_24515(), InitSounds.COMPASS_POINT, class_3419.field_15248, 0.8f, 1.5f);
                return class_1269.field_5812;
            }
            class_2487 tag = compass.method_7941("KappaCompassData");
            class_2960 dimension = getDimension(compass);
            if (tag != null || dimension != null) {
                if (!maid.field_6002.method_27983().method_29177().equals(dimension)) {
                    player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.maid_dimension_check"));
                    return class_1269.field_21466;
                }
                maid.getSchedulePos().setDimension(dimension);
                class_2338 point = getPoint(class_4168.field_18596, compass);
                if (point != null) {
                    maid.getSchedulePos().setWorkPos(point);
                }
                point = getPoint(class_4168.field_18595, compass);
                if (point != null) {
                    maid.getSchedulePos().setIdlePos(point);
                }
                point = getPoint(class_4168.field_18597, compass);
                if (point != null) {
                    maid.getSchedulePos().setSleepPos(point);
                }
                maid.getSchedulePos().setConfigured(true);
                maid.getSchedulePos().restrictTo(maid);
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.maid_write"));
                player.field_6002.method_8396(null, player.method_24515(), InitSounds.COMPASS_POINT, class_3419.field_15248, 0.8f, 1.5f);
                return class_1269.field_5812;
            }
            player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.no_data"));
            return class_1269.field_21466;
        }
        return super.method_7847(compass, player, livingEntity, hand);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1799 compass = context.method_8041();
        class_2338 clickedPos = context.method_8037();
        if (player == null || context.method_8045().field_9236) {
            return super.method_7884(context);
        }
        if (player.method_21751()) {
            compass.method_7983("KappaCompassData");
            player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.clear"));
        } else {
            int recordCount = getRecordCount(compass);
            if (recordCount >= 3) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.full"));
            } else if (recordCount == 2) {
                class_2338 idlePos = getPoint(class_4168.field_18595, compass);
                if (idlePos != null && idlePos.method_10262(clickedPos) > 64 * 64) {
                    player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.far_away"));
                    return super.method_7884(context);
                }
                addPoint(class_4168.field_18597, clickedPos, compass);
                player.method_43496(class_2561.method_43469("message.touhou_little_maid.kappa_compass.sleep", clickedPos.method_10263(), clickedPos.method_10264(), clickedPos.method_10260()));
            } else if (recordCount == 1) {
                class_2338 workPos = getPoint(class_4168.field_18596, compass);
                if (workPos != null && workPos.method_10262(clickedPos) > 64 * 64) {
                    player.method_43496(class_2561.method_43471("message.touhou_little_maid.kappa_compass.far_away"));
                    return super.method_7884(context);
                }
                addPoint(class_4168.field_18595, clickedPos, compass);
                player.method_43496(class_2561.method_43469("message.touhou_little_maid.kappa_compass.idle", clickedPos.method_10263(), clickedPos.method_10264(), clickedPos.method_10260()));
            } else {
                addPoint(class_4168.field_18596, clickedPos, compass);
                player.method_43496(class_2561.method_43469("message.touhou_little_maid.kappa_compass.work", clickedPos.method_10263(), clickedPos.method_10264(), clickedPos.method_10260()));
            }
            addDimension(player.field_6002.method_27983().method_29177(), compass);
        }
        player.field_6002.method_8396(null, player.method_24515(), InitSounds.COMPASS_POINT, class_3419.field_15248, 0.8f, 1.5f);
        return class_1269.field_5812;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 pLevel, List<class_2561> components, class_1836 pIsAdvanced) {
        if (hasKappaCompassData(stack)) {
            class_2960 dimension = getDimension(stack);
            class_2338 workPos = getPoint(class_4168.field_18596, stack);
            class_2338 idlePos = getPoint(class_4168.field_18595, stack);
            class_2338 sleepPos = getPoint(class_4168.field_18597, stack);
            if (dimension != null) {
                components.add(class_2561.method_43469("tooltips.touhou_little_maid.fox_scroll.dimension", dimension.toString()).method_27692(class_124.field_1065));
            }
            if (workPos != null) {
                components.add(class_2561.method_43469("message.touhou_little_maid.kappa_compass.work", workPos.method_10263(), workPos.method_10264(), workPos.method_10260()).method_27692(class_124.field_1061));
            }
            if (idlePos != null) {
                components.add(class_2561.method_43469("message.touhou_little_maid.kappa_compass.idle", idlePos.method_10263(), idlePos.method_10264(), idlePos.method_10260()).method_27692(class_124.field_1060));
            }
            if (sleepPos != null) {
                components.add(class_2561.method_43469("message.touhou_little_maid.kappa_compass.sleep", sleepPos.method_10263(), sleepPos.method_10264(), sleepPos.method_10260()).method_27692(class_124.field_1078));
            }
            components.add(class_2561.method_43473());
        }
        components.add(class_2561.method_43471("message.touhou_little_maid.kappa_compass.usage.set_pos"));
        components.add(class_2561.method_43471("message.touhou_little_maid.kappa_compass.usage.clear_pos"));
        components.add(class_2561.method_43471("message.touhou_little_maid.kappa_compass.usage.write_pos_to_maid"));
        components.add(class_2561.method_43471("message.touhou_little_maid.kappa_compass.usage.clear_maid_pos"));
    }
}