package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class DismountMessage {
    public static final int DISMOUNT_BROOM = 1;
    public static final class_2960 ID = new class_2960(TouhouLittleMaid.MOD_ID, "dismount");

    public static class_2540 encode(int action) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(action);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 sender, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int action = buf.readInt();
        server.execute(() -> onHandle(action, sender));
    }

    private static void onHandle(int action, class_3222 sender) {
        // 处理卸载扫帚的逻辑
        if (action == DISMOUNT_BROOM && sender.method_5854() instanceof EntityBroom) {
            sender.method_5848();
        }
    }
}