package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.FoxScrollScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import java.util.List;
import java.util.Map;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class FoxScrollMessage {
    public static final class_2960 ID = getResourceLocation("fox_scroll");

    public static class_2540 encode(Map<String, List<FoxScrollData>> data) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(data.size());
        data.forEach((dim, scrollData) -> {
            buf.method_10804(scrollData.size());
            buf.method_10814(dim);
            scrollData.forEach(foxScrollData -> FoxScrollData.encode(foxScrollData, buf));
        });
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        Map<String, List<FoxScrollData>> data = Maps.newHashMap();
        int dimLength = buf.method_10816();
        for (int i = 0; i < dimLength; i++) {
            List<FoxScrollData> scrollData = Lists.newArrayList();
            int dataLength = buf.method_10816();
            String dim = buf.method_19772();
            for (int j = 0; j < dataLength; j++) {
                scrollData.add(FoxScrollData.decode(buf));
            }
            data.put(dim, scrollData);
        }
        client.execute(() -> onHandle(data));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(Map<String, List<FoxScrollData>> data) {
        class_310.method_1551().method_1507(new FoxScrollScreen(data));
    }

    public static class FoxScrollData {
        private final class_2338 pos;
        private final class_2561 name;
        private final long timestamp;

        public FoxScrollData(class_2338 pos, class_2561 name, long timestamp) {
            this.pos = pos;
            this.name = name;
            this.timestamp = timestamp;
        }

        public static void encode(FoxScrollData data, class_2540 buf) {
            buf.method_10807(data.pos);
            buf.method_10805(data.name);
            buf.writeLong(data.timestamp);
        }

        public static FoxScrollData decode(class_2540 buf) {
            return new FoxScrollData(buf.method_10811(), buf.method_10808(), buf.readLong());
        }

        public class_2338 getPos() {
            return pos;
        }

        public class_2561 getName() {
            return name;
        }

        public long getTimestamp() {
            return timestamp;
        }
    }
}
