package com.github.tartaricacid.touhoulittlemaid.network.message;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_490;
import net.minecraft.class_634;
import net.minecraft.class_746;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

/**
 * 与扫帚骑乘有关的消息，从服务端到客户端
 */
public class OpenPlayerInventoryMessage {
    public static final class_2960 ID = getResourceLocation("open_player_inv");
    public static final int OPEN_PLAYER_INVENTORY = 0;

    public static class_2540 encode(int action) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(action);
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int action = buf.readInt();
        client.execute(() -> onHandle(action));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(int action) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (action == OPEN_PLAYER_INVENTORY) {
            // 打开玩家背包
            class_310.method_1551().method_1507(new class_490(player));
        }
    }
}