package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class SyncDataMessage {
    public static final class_2960 ID = getResourceLocation("sync_data");

    public static class_2540 encode(float power, int maidNum) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeFloat(power);
        buf.method_10804(maidNum);
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        float power = buf.readFloat();
        int maidNum = buf.method_10816();
        client.execute(() -> handleData(power, maidNum));
    }

    @Environment(EnvType.CLIENT)
    private static void handleData(float power, final int maidNum) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        mc.field_1724.setAttached(InitDataAttachment.POWER_NUM, new PowerAttachment(power));
        mc.field_1724.setAttached(InitDataAttachment.MAID_NUM, new MaidNumAttachment(maidNum));
    }
}