package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.AltarItemHandler;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public class TileEntityAltar extends class_2586 implements IBlockEntityPersistentData {
    public static final class_2591<TileEntityAltar> TYPE = class_2591.class_2592.method_20528(TileEntityAltar::new, InitBlocks.ALTAR).method_11034(null);
    private static final String STORAGE_ITEM = "StorageItem";
    private static final String IS_RENDER = "IsRender";
    private static final String CAN_PLACE_ITEM = "CanPlaceItem";
    private static final String STORAGE_STATE_ID = "StorageBlockStateId";
    private static final String DIRECTION = "Direction";
    private static final String STORAGE_BLOCK_LIST = "StorageBlockList";
    private static final String CAN_PLACE_ITEM_POS_LIST = "CanPlaceItemPosList";
    public final ItemStackHandler handler = new AltarItemHandler();
    private boolean isRender = false;
    private boolean canPlaceItem = false;
    private class_2680 storageState = class_2246.field_10124.method_9564();
    private PosListData blockPosList = new PosListData();
    private PosListData canPlaceItemPosList = new PosListData();
    private class_2350 direction = class_2350.field_11035;

    public TileEntityAltar(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void setForgeData(class_2680 storageState, boolean isRender, boolean canPlaceItem, class_2350 direction,
                             PosListData blockPosList, PosListData canPlaceItemPosList) {
        this.isRender = isRender;
        this.canPlaceItem = canPlaceItem;
        this.storageState = storageState;
        this.direction = direction;
        this.blockPosList = blockPosList;
        this.canPlaceItemPosList = canPlaceItemPosList;
        refresh();
    }

    @Override
    public void method_11007(class_2487 pTag) {
        tlm$getPersistentData().method_10556(IS_RENDER, isRender);
        tlm$getPersistentData().method_10556(CAN_PLACE_ITEM, canPlaceItem);
        tlm$getPersistentData().method_10569(STORAGE_STATE_ID, class_2248.method_9507(storageState));
        tlm$getPersistentData().method_10566(STORAGE_ITEM, handler.serializeNBT());
        tlm$getPersistentData().method_10582(DIRECTION, direction.method_15434());
        tlm$getPersistentData().method_10566(STORAGE_BLOCK_LIST, blockPosList.serialize());
        tlm$getPersistentData().method_10566(CAN_PLACE_ITEM_POS_LIST, canPlaceItemPosList.serialize());
        super.method_11007(pTag);
    }

    @Override
    public void method_11014(class_2487 pTag) {
        super.method_11014(pTag);
        isRender = tlm$getPersistentData().method_10577(IS_RENDER);
        canPlaceItem = tlm$getPersistentData().method_10577(CAN_PLACE_ITEM);
        storageState = class_2248.method_9531(tlm$getPersistentData().method_10550(STORAGE_STATE_ID));
        handler.deserializeNBT(tlm$getPersistentData().method_10562(STORAGE_ITEM));
        direction = class_2350.method_10168(tlm$getPersistentData().method_10558(DIRECTION));
        blockPosList.deserialize(tlm$getPersistentData().method_10554(STORAGE_BLOCK_LIST, class_2520.field_33260));
        canPlaceItemPosList.deserialize(tlm$getPersistentData().method_10554(CAN_PLACE_ITEM_POS_LIST, class_2520.field_33260));
    }

    public class_2338 getWorldPosition() {
        return this.field_11867;
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public void refresh() {
        this.method_5431();
        if (field_11863 != null) {
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31036);
        }
    }

    public boolean isRender() {
        return isRender;
    }

    public boolean isCanPlaceItem() {
        return canPlaceItem;
    }

    public class_2680 getStorageState() {
        return storageState;
    }

    public PosListData getBlockPosList() {
        return blockPosList;
    }

    public PosListData getCanPlaceItemPosList() {
        return canPlaceItemPosList;
    }

    public class_1799 getStorageItem() {
        if (canPlaceItem) {
            return handler.getStackInSlot(0);
        }
        return class_1799.field_8037;
    }

    public class_2350 getDirection() {
        return direction;
    }
}
