package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public class TileEntityShrine extends class_2586 implements IBlockEntityPersistentData {
    public static final class_2591<TileEntityShrine> TYPE = class_2591.class_2592.method_20528(TileEntityShrine::new, InitBlocks.SHRINE).method_11034(null);
    private static final String STORAGE_ITEM = "StorageItem";
    private final ItemStackHandler handler = new ItemStackHandler() {
        @Override
        protected void onContentsChanged(int slot) {
            // 当物品栏内容发生变化时，这个方法会被调用
            // 我们需要在这里调用 refresh() 来通知 Minecraft 该方块实体的数据已更新，需要保存并同步到客户端
            refresh();
        }

        @Override
        public boolean isItemValid(int slot, @NotNull class_1799 stack) {
            return stack.method_7909() == InitItems.FILM;
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public TileEntityShrine(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
    }

    @Override
    protected void method_11007(class_2487 tag) {
        tlm$getPersistentData().method_10566(STORAGE_ITEM, handler.serializeNBT());
        super.method_11007(tag);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        handler.deserializeNBT(tlm$getPersistentData().method_10562(STORAGE_ITEM));
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public void refresh() {
        this.method_5431();
        if (field_11863 != null) {
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31036);
        }
    }

    public class_1799 getStorageItem() {
        return handler.getStackInSlot(0);
    }

    public void insertStorageItem(class_1799 stack) {
        handler.insertItem(0, stack, false);
    }

    public class_1799 extractStorageItem() {
        return handler.extractItem(0, 1, false);
    }

    public boolean isEmpty() {
        return handler.getStackInSlot(0).method_7960();
    }

    public boolean canInsert(class_1799 stack) {
        return handler.isItemValid(0, stack);
    }
}
