package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class TileEntityWChess extends TileEntityJoy implements IBoardGameEntityBlock {
    public static final class_2591<TileEntityWChess> TYPE = class_2591.class_2592.method_20528(TileEntityWChess::new, InitBlocks.WCHESS).method_11034(null);

    private static final String CHESS_DATA = "ChessData";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String SELECT_CHESS_POINT = "SelectChessPoint";
    private static final String CHECKMATE = "Checkmate";
    private static final String REPEAT = "Repeat";
    private static final String MOVE_NUMBER_LIMIT = "MoveNumberLimit";

    private final Position chessData;

    // 回合计数器
    private int chessCounter = 0;
    // 当前选中的棋子
    private int selectChessPoint = 0;
    // 将死（依据下棋方，判断谁输谁赢）
    private boolean checkmate = false;
    // 长打（判和）
    private boolean repeat = false;
    // 50 回限着（判和）
    private boolean moveNumberLimit = false;

    public TileEntityWChess(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
        this.chessData = new Position();
        this.chessData.fromFen(WChessUtil.INIT);
    }

    @Override
    protected void method_11007(class_2487 tag) {
        class_2487 data = tlm$getPersistentData();
        data.method_10582(CHESS_DATA, chessData.toFen());
        data.method_10569(CHESS_COUNTER, chessCounter);
        data.method_10569(SELECT_CHESS_POINT, selectChessPoint);
        data.method_10556(CHECKMATE, checkmate);
        data.method_10556(REPEAT, repeat);
        data.method_10556(MOVE_NUMBER_LIMIT, moveNumberLimit);
        super.method_11007(tag);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2487 data = tlm$getPersistentData();
        chessCounter = data.method_10550(CHESS_COUNTER);
        selectChessPoint = data.method_10550(SELECT_CHESS_POINT);
        chessData.fromFen(data.method_10558(CHESS_DATA));
        checkmate = data.method_10577(CHECKMATE);
        repeat = data.method_10577(REPEAT);
        moveNumberLimit = data.method_10577(MOVE_NUMBER_LIMIT);
    }

    public void reset() {
        this.chessCounter = 0;
        this.selectChessPoint = 0;
        this.chessData.fromFen(WChessUtil.INIT);
        this.checkmate = false;
        this.repeat = false;
        this.moveNumberLimit = false;
    }

    public Position getChessData() {
        return chessData;
    }

    public boolean isCheckmate() {
        return checkmate;
    }

    public void setCheckmate(boolean checkmate) {
        this.checkmate = checkmate;
    }

    public boolean isPlayerTurn() {
        return WChessUtil.isPlayer(this.chessData);
    }

    public int getChessCounter() {
        return chessCounter;
    }

    public void addChessCounter() {
        this.chessCounter += 1;
    }

    public int getSelectChessPoint() {
        return selectChessPoint;
    }

    public void setSelectChessPoint(int selectChessPoint) {
        this.selectChessPoint = selectChessPoint;
    }

    public boolean isRepeat() {
        return repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean isMoveNumberLimit() {
        return moveNumberLimit;
    }

    public void setMoveNumberLimit(boolean moveNumberLimit) {
        this.moveNumberLimit = moveNumberLimit;
    }
}
