/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public record ChatClientInfo(String language, String name, List<String> description) {
    public void encode(class_2540 buf) {
        buf.method_10814(this.language);
        buf.method_10814(this.name);
        buf.method_10804(this.description.size());
        for (String line : this.description) {
            buf.method_10814(line);
        }
    }

    public static ChatClientInfo decode(class_2540 buf) {
        String language = buf.method_19772();
        String name = buf.method_19772();
        int size = buf.method_10816();
        ArrayList description = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            description.add(buf.method_19772());
        }
        return new ChatClientInfo(language, name, description);
    }

    @Environment(value=EnvType.CLIENT)
    public static ChatClientInfo fromMaid(EntityMaid maid) {
        String language = ChatClientInfo.getClientLanguage();
        String name = ChatClientInfo.getMaidName(maid);
        List<String> description = ChatClientInfo.getMaidDescription(maid);
        return new ChatClientInfo(language, name, description);
    }

    @Environment(value=EnvType.CLIENT)
    private static String getClientLanguage() {
        return class_310.method_1551().method_1526().method_4669();
    }

    @Environment(value=EnvType.CLIENT)
    private static String getMaidName(EntityMaid maid) {
        return maid.method_5477().getString();
    }

    @Environment(value=EnvType.CLIENT)
    private static List<String> getMaidDescription(EntityMaid maid) {
        ArrayList description = Lists.newArrayList();
        if (YsmCompat.isInstalled() && maid.isYsmModel()) {
            return description;
        }
        Optional<MaidModelInfo> info = CustomPackLoader.MAID_MODELS.getInfo(maid.getModelId());
        if (info.isPresent()) {
            MaidModelInfo maidModelInfo = info.get();
            List<class_2561> parse = ParseI18n.parse(maidModelInfo.getDescription());
            parse.forEach(component -> description.add(component.getString()));
        }
        return description;
    }
}

