/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.stt;

import com.github.tartaricacid.touhoulittlemaid.ai.service.Client;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTConfig;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface STTClient
extends Client {
    public void startRecord(STTConfig var1, ResponseCallback<String> var2);

    public void stopRecord(STTConfig var1, ResponseCallback<String> var2);

    default public <T> void handleResponse(ResponseCallback<String> callback, HttpResponse<String> response, @Nullable Throwable throwable, HttpRequest request, Consumer<T> onSuccess, Type type) {
        if (throwable != null) {
            callback.onFailure(request, throwable, 0);
            return;
        }
        try {
            String string = response.body();
            int statusCode = response.statusCode();
            if (this.isSuccessful(response)) {
                Object message = GSON.fromJson(string, type);
                onSuccess.accept(message);
            } else {
                String message = "HTTP Error Code: %d, Response %s".formatted(statusCode, response);
                callback.onFailure(request, new Throwable(message), 1);
            }
        }
        catch (JsonSyntaxException e) {
            String message = "Exception %s, JSON is: %s".formatted(e.getLocalizedMessage(), response.body());
            callback.onFailure(request, new Throwable(message), 2);
        }
    }
}

