/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.event;

import cn.sh1rocu.touhoulittlemaid.api.event.CancellableEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;

public class MaidTaskEnableEvent
extends CancellableEvent {
    private final IMaidTask targetTask;
    private final EntityMaid entityMaid;
    private final List<Pair<String, Predicate<EntityMaid>>> enableConditionDesc;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onMaidTaskEnable(event);
        }
    });

    public MaidTaskEnableEvent(IMaidTask targetTask, EntityMaid entityMaid, List<Pair<String, Predicate<EntityMaid>>> enableConditionDesc) {
        this.targetTask = targetTask;
        this.entityMaid = entityMaid;
        this.enableConditionDesc = enableConditionDesc;
    }

    public MaidTaskEnableEvent(IMaidTask targetTask, EntityMaid entityMaid) {
        this.targetTask = targetTask;
        this.entityMaid = entityMaid;
        this.enableConditionDesc = Lists.newArrayList();
    }

    public IMaidTask getTargetTask() {
        return this.targetTask;
    }

    public EntityMaid getEntityMaid() {
        return this.entityMaid;
    }

    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc() {
        return this.enableConditionDesc;
    }

    public void addEnableConditionDesc(String desc, Predicate<EntityMaid> predicate) {
        this.enableConditionDesc.add((Pair<String, Predicate<EntityMaid>>)Pair.of((Object)desc, predicate));
    }

    public static interface Callback {
        public void onMaidTaskEnable(MaidTaskEnableEvent var1);
    }
}

