/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.event.client;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import java.util.Map;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_332;
import net.minecraft.class_339;

public abstract class MaidContainerGuiEvent {
    protected final AbstractMaidContainerGui<?> gui;
    protected final int leftPos;
    protected final int topPos;
    protected final Map<String, class_339> buttons;
    public static final Event<Init.Callback> INIT = EventFactory.createArrayBacked(Init.Callback.class, callbacks -> event -> {
        for (Init.Callback callback : callbacks) {
            callback.onInit(event);
        }
    });
    public static final Event<Render.Callback> RENDER = EventFactory.createArrayBacked(Render.Callback.class, callbacks -> event -> {
        for (Render.Callback callback : callbacks) {
            callback.onRender(event);
        }
    });
    public static final Event<Tooltip.Callback> TOOLTIP = EventFactory.createArrayBacked(Tooltip.Callback.class, callbacks -> event -> {
        for (Tooltip.Callback callback : callbacks) {
            callback.onTooltip(event);
        }
    });

    public MaidContainerGuiEvent(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, class_339> buttons) {
        this.gui = gui;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.buttons = buttons;
    }

    public AbstractMaidContainerGui<?> getGui() {
        return this.gui;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public class_339 getButton(String name) {
        return this.buttons.get(name);
    }

    public boolean hasButton(String name) {
        return this.buttons.containsKey(name);
    }

    public static class Tooltip
    extends MaidContainerGuiEvent {
        private final class_332 graphics;
        private final int mouseX;
        private final int mouseY;
        private final float partialTicks;

        public Tooltip(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, class_339> buttons, class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super(gui, leftPos, topPos, buttons);
            this.graphics = graphics;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.partialTicks = partialTicks;
        }

        public class_332 getGraphics() {
            return this.graphics;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getPartialTicks() {
            return this.partialTicks;
        }

        public static interface Callback {
            public void onTooltip(Tooltip var1);
        }
    }

    public static class Render
    extends MaidContainerGuiEvent {
        private final class_332 graphics;
        private final int mouseX;
        private final int mouseY;
        private final float partialTicks;

        public Render(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, class_339> buttons, class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super(gui, leftPos, topPos, buttons);
            this.graphics = graphics;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.partialTicks = partialTicks;
        }

        public class_332 getGraphics() {
            return this.graphics;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getPartialTicks() {
            return this.partialTicks;
        }

        public static interface Callback {
            public void onRender(Render var1);
        }
    }

    public static class Init
    extends MaidContainerGuiEvent {
        public Init(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, class_339> buttons) {
            super(gui, leftPos, topPos, buttons);
        }

        public void addButton(String name, class_339 button) {
            if (!this.buttons.containsKey(name)) {
                this.buttons.put(name, button);
            }
        }

        public void removeButton(String name) {
            this.buttons.remove(name);
        }

        public static interface Callback {
            public void onInit(Init var1);
        }
    }
}

