/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.chess;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Util;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;

public class Position {
    public static final int MATE_VALUE = 10000;
    public static final int WIN_VALUE = 9900;
    public static final int NULL_SAFE_MARGIN = 1000;
    public static final int NULL_OKAY_MARGIN = 500;
    public static final int DRAW_VALUE = 50;
    public static final int ADVANCED_VALUE = 10;
    public static final int MAX_MOVE_NUM = 256;
    public static final int MAX_GEN_MOVES = 128;
    public static final int MAX_BOOK_SIZE = 16384;
    public static final int PIECE_KING = 0;
    public static final int PIECE_QUEEN = 1;
    public static final int PIECE_ROOK = 2;
    public static final int PIECE_BISHOP = 3;
    public static final int PIECE_KNIGHT = 4;
    public static final int PIECE_PAWN = 5;
    public static final int DIFF_LINE = 0;
    public static final int SAME_RANK = 1;
    public static final int SAME_FILE = 2;
    public static final int SAME_DIAG_A1H8 = 3;
    public static final int SAME_DIAG_A8H1 = 4;
    public static final int RANK_TOP = 0;
    public static final int RANK_BOTTOM = 7;
    public static final int FILE_LEFT = 4;
    public static final int FILE_RIGHT = 11;
    public static final byte[] LEGAL_SPAN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] SAME_LINE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 3, 0, 0, 4, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 4, 0, 0, 0, 0, 2, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 2, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 2, 3, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 3, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 2, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 4, 0, 0, 3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] PAWN_LINE = new byte[]{0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0};
    public static final int[] KING_DELTA = new int[]{-17, -16, -15, -1, 1, 15, 16, 17};
    public static final int[] ROOK_DELTA = new int[]{-16, -1, 1, 16};
    public static final int[] BISHOP_DELTA = new int[]{-17, -15, 15, 17};
    public static final int[] KNIGHT_DELTA = new int[]{-33, -31, -18, -14, 14, 18, 31, 33};
    public static final int[] MMV_VALUE = new int[]{0, 900, 500, 300, 300, 100};
    public static final int[] CASTLING_DIRECTION = new int[]{1, -1, 1, -1};
    public static final int[] CASTLING_KING_SRC = new int[]{120, 120, 8, 8};
    public static final int[] CASTLING_ROOK_DST = new int[]{121, 119, 9, 7};
    public static final int[] CASTLING_KING_DST = new int[]{122, 118, 10, 6};
    public static final int[] CASTLING_ROOK_SRC = new int[]{123, 116, 11, 4};
    public static final String PIECE_STRING = "KQRBNP";
    public static final String[] STARTUP_FEN = new String[]{"rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/R1BQKBNR w KQkq - 0 1", "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/1NBQKBNR w KQkq - 0 1", "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNB1KBNR w KQkq - 0 1"};
    public static int PreGen_zobristKeyPlayer;
    public static int PreGen_zobristLockPlayer;
    public static int[][] PreGen_zobristKeyTable;
    public static int[][] PreGen_zobristLockTable;
    public static Random random;
    public static int bookSize;
    public static int[] bookLock;
    public static short[] bookMove;
    public static short[] bookValue;
    public int sdPlayer;
    public byte[] squares = new byte[128];
    public int zobristKey;
    public int zobristLock;
    public int vlWhite;
    public int vlBlack;
    public int moveNum;
    public int distance;
    public int[] mvList = new int[256];
    public int[] pcList = new int[256];
    public int[] keyList = new int[256];
    public boolean[] chkList = new boolean[256];
    public boolean[] specialMoveList = new boolean[256];
    public int[] castlingBitsList = new int[256];
    public int[] sqEnPassantList = new int[256];
    public int[] brWhitePawn = new int[8];
    public int[] brBlackPawn = new int[8];
    public short[][] vlWhitePiecePos = new short[6][128];
    public short[][] vlBlackPiecePos = new short[6][128];
    public static final String FEN_PIECE = "        KQRBNP  kqrbnp  ";
    public static final String CASTLING_CHAR = "KQkq";

    public static boolean IN_BOARD(int sq) {
        return (sq - 4 & 0x88) == 0;
    }

    public static int RANK_Y(int sq) {
        return sq >> 4;
    }

    public static int FILE_X(int sq) {
        return sq & 0xF;
    }

    public static int COORD_XY(int x, int y) {
        return x + (y << 4);
    }

    public static int SQUARE_FLIP(int sq) {
        return 127 - sq;
    }

    public static int SQUARE_FORWARD(int sq, int sd) {
        return sq - 16 + (sd << 5);
    }

    public static int FORWARD_DELTA(int sd) {
        return (sd << 5) - 16;
    }

    public static boolean PAWN_INIT(int sq, int sd) {
        return PAWN_LINE[sq] == sd + 1;
    }

    public static boolean PAWN_PROMOTION(int sq, int sd) {
        return PAWN_LINE[sq] == sd + 3;
    }

    public static boolean PAWN_EN_PASSANT(int sq, int sd) {
        return PAWN_LINE[sq] == sd + 5;
    }

    public static boolean KING_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 128] == 1;
    }

    public static boolean KNIGHT_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 128] == 2;
    }

    public static int SAME_LINE(int sqSrc, int sqDst) {
        return SAME_LINE[sqDst - sqSrc + 128];
    }

    public static int CASTLING_TYPE(int sd, int sqSrc, int sqDst) {
        return (sd << 1) + (sqDst > sqSrc ? 0 : 1);
    }

    public static int SIDE_TAG(int sd) {
        return 8 + (sd << 3);
    }

    public static int OPP_SIDE_TAG(int sd) {
        return 16 - (sd << 3);
    }

    public static int SRC(int mv) {
        return mv & 0x7F;
    }

    public static int DST(int mv) {
        return mv >> 7;
    }

    public static int MOVE(int sqSrc, int sqDst) {
        return sqSrc + (sqDst << 7);
    }

    public static int PIECE_TYPE(int pc) {
        return pc & 7;
    }

    public static int MVV_LVA(int pc, int lva) {
        return MMV_VALUE[Position.PIECE_TYPE(pc)] - lva;
    }

    public static int PARSE_COORD(String str, int index) {
        int sq = 0;
        if (index == str.length()) {
            return 0;
        }
        char c = str.charAt(index);
        if (c >= 'a' && c <= 'h') {
            if (index + 1 == str.length()) {
                return 0;
            }
            char c2 = str.charAt(index + 1);
            if (c2 >= '1' && c2 <= '8') {
                sq = Position.COORD_XY(c - 97 + 4, 56 - c2 + 0);
            }
        }
        return sq;
    }

    public static int PARSE_MOVE(String str) {
        return Position.PARSE_MOVE(str, 0);
    }

    public static int PARSE_MOVE(String str, int index) {
        return Position.MOVE(Position.PARSE_COORD(str, index), Position.PARSE_COORD(str, index + 2));
    }

    public static String SQUARE_STR(int sq) {
        return "" + (char)(97 + Position.FILE_X(sq) - 4) + (char)(56 - Position.RANK_Y(sq) + 0);
    }

    public static String MOVE_STR(int mv) {
        return Position.SQUARE_STR(Position.SRC(mv)) + Position.SQUARE_STR(Position.DST(mv));
    }

    public void clearBoard() {
        this.sdPlayer = 0;
        for (int sq = 0; sq < 128; ++sq) {
            this.squares[sq] = 0;
        }
        for (int i = 0; i < 8; ++i) {
            this.brBlackPawn[i] = 0;
            this.brWhitePawn[i] = 0;
        }
        this.zobristLock = 0;
        this.zobristKey = 0;
        this.vlBlack = 0;
        this.vlWhite = 0;
    }

    public boolean captured() {
        return this.pcList[this.moveNum - 1] > 0;
    }

    public boolean inCheck() {
        return this.chkList[this.moveNum - 1];
    }

    public boolean specialMove() {
        return this.specialMoveList[this.moveNum - 1];
    }

    public int castlingBits() {
        return this.castlingBitsList[this.moveNum - 1];
    }

    public int enPassantSquare() {
        return this.sqEnPassantList[this.moveNum - 1];
    }

    public boolean canCastling(int castling) {
        if (!this.inCheck() && (this.castlingBits() & 1 << castling) != 0) {
            int delta = CASTLING_DIRECTION[castling];
            int sqDst = CASTLING_ROOK_SRC[castling];
            for (int sqSrc = CASTLING_KING_SRC[castling] + delta; sqSrc != sqDst; sqSrc += delta) {
                if (this.squares[sqSrc] <= 0) continue;
                return false;
            }
            return !this.checked(CASTLING_ROOK_DST[castling]);
        }
        return false;
    }

    public void setIrrev() {
        this.setIrrev(this.castlingBits(), this.enPassantSquare());
    }

    public void setIrrev(int castlingBits, int sqEnPassant) {
        this.pcList[0] = 0;
        this.mvList[0] = 0;
        this.castlingBitsList[0] = castlingBits;
        this.sqEnPassantList[0] = sqEnPassant;
        this.chkList[0] = this.checked();
        this.moveNum = 1;
        this.distance = 0;
    }

    public void addPiece(int sq, int pc, boolean del) {
        int pcAdjust;
        this.squares[sq] = (byte)(del ? 0 : pc);
        if (pc < 16) {
            if (pc == 13) {
                int n = Position.RANK_Y(sq);
                this.brWhitePawn[n] = this.brWhitePawn[n] ^ 1 << Position.FILE_X(sq);
            }
            pcAdjust = pc - 8;
            this.vlWhite += del ? -this.vlWhitePiecePos[pcAdjust][sq] : this.vlWhitePiecePos[pcAdjust][sq];
        } else {
            if (pc == 21) {
                int n = Position.RANK_Y(sq);
                this.brBlackPawn[n] = this.brBlackPawn[n] ^ 1 << Position.FILE_X(sq);
            }
            pcAdjust = pc - 16;
            this.vlBlack += del ? -this.vlBlackPiecePos[pcAdjust][sq] : this.vlBlackPiecePos[pcAdjust][sq];
            pcAdjust += 6;
        }
        this.zobristKey ^= PreGen_zobristKeyTable[pcAdjust][sq];
        this.zobristLock ^= PreGen_zobristLockTable[pcAdjust][sq];
    }

    public void addPiece(int sq, int pc) {
        this.addPiece(sq, pc, false);
    }

    public void delPiece(int sq, int pc) {
        this.addPiece(sq, pc, true);
    }

    public void movePiece() {
        int castling;
        int sqSrc = Position.SRC(this.mvList[this.moveNum]);
        int sqDst = Position.DST(this.mvList[this.moveNum]);
        int pcCaptured = this.squares[sqDst];
        if (pcCaptured > 0) {
            this.delPiece(sqDst, pcCaptured);
        }
        byte pc = this.squares[sqSrc];
        this.delPiece(sqSrc, pc);
        this.addPiece(sqDst, pc);
        this.pcList[this.moveNum] = pcCaptured;
        this.specialMoveList[this.moveNum] = false;
        this.castlingBitsList[this.moveNum] = this.castlingBits();
        this.sqEnPassantList[this.moveNum] = 0;
        if (Position.PIECE_TYPE(pcCaptured) == 2) {
            castling = 1 - this.sdPlayer << 1;
            if (sqDst == CASTLING_ROOK_SRC[castling]) {
                int n = this.moveNum;
                this.castlingBitsList[n] = this.castlingBitsList[n] & ~(1 << castling);
            } else if (sqDst == CASTLING_ROOK_SRC[castling + 1]) {
                int n = this.moveNum;
                this.castlingBitsList[n] = this.castlingBitsList[n] & ~(1 << castling + 1);
            }
        }
        if (Position.PIECE_TYPE(pc) == 0) {
            if (!Position.KING_SPAN(sqSrc, sqDst)) {
                castling = Position.CASTLING_TYPE(this.sdPlayer, sqSrc, sqDst);
                this.delPiece(CASTLING_ROOK_SRC[castling], pc - 0 + 2);
                this.addPiece(CASTLING_ROOK_DST[castling], pc - 0 + 2);
                this.specialMoveList[this.moveNum] = true;
            }
            int n = this.moveNum;
            this.castlingBitsList[n] = this.castlingBitsList[n] & ~(3 << (this.sdPlayer << 1));
        } else if (Position.PIECE_TYPE(pc) == 5) {
            if (Position.PAWN_PROMOTION(sqDst, this.sdPlayer)) {
                this.delPiece(sqDst, pc);
                this.addPiece(sqDst, pc - 5 + 1);
                this.specialMoveList[this.moveNum] = true;
            } else if (sqDst == this.enPassantSquare()) {
                int sqCaptured = sqDst - Position.FORWARD_DELTA(this.sdPlayer);
                pcCaptured = this.squares[sqCaptured];
                this.delPiece(sqCaptured, pcCaptured);
                this.pcList[this.moveNum] = pcCaptured;
                this.specialMoveList[this.moveNum] = true;
            } else {
                int delta = Position.FORWARD_DELTA(this.sdPlayer);
                if (sqDst == sqSrc + (delta << 1)) {
                    this.sqEnPassantList[this.moveNum] = sqSrc + delta;
                }
            }
        } else if (Position.PIECE_TYPE(pc) == 2) {
            castling = this.sdPlayer << 1;
            if (sqSrc == CASTLING_ROOK_SRC[castling]) {
                int n = this.moveNum;
                this.castlingBitsList[n] = this.castlingBitsList[n] & ~(1 << castling);
            } else if (sqSrc == CASTLING_ROOK_SRC[castling + 1]) {
                int n = this.moveNum;
                this.castlingBitsList[n] = this.castlingBitsList[n] & ~(1 << castling + 1);
            }
        }
    }

    public void undoMovePiece() {
        int sqSrc = Position.SRC(this.mvList[this.moveNum]);
        int sqDst = Position.DST(this.mvList[this.moveNum]);
        byte pc = this.squares[sqDst];
        this.delPiece(sqDst, pc);
        this.addPiece(sqSrc, pc);
        if (this.pcList[this.moveNum] > 0) {
            this.addPiece(sqDst, this.pcList[this.moveNum]);
        }
        if (this.specialMoveList[this.moveNum]) {
            if (Position.PIECE_TYPE(pc) == 0) {
                int castling = Position.CASTLING_TYPE(this.sdPlayer, sqSrc, sqDst);
                this.delPiece(CASTLING_ROOK_DST[castling], pc - 0 + 2);
                this.addPiece(CASTLING_ROOK_SRC[castling], pc - 0 + 2);
            } else if (Position.PAWN_PROMOTION(sqDst, this.sdPlayer)) {
                this.delPiece(sqSrc, pc);
                this.addPiece(sqSrc, pc - 1 + 5);
            } else {
                this.delPiece(sqDst, this.pcList[this.moveNum]);
                this.addPiece(sqDst - Position.FORWARD_DELTA(this.sdPlayer), this.pcList[this.moveNum]);
            }
        }
    }

    public void changeSide() {
        this.sdPlayer = 1 - this.sdPlayer;
        this.zobristKey ^= PreGen_zobristKeyPlayer;
        this.zobristLock ^= PreGen_zobristLockPlayer;
    }

    public boolean makeMove(int mv) {
        this.keyList[this.moveNum] = this.zobristKey;
        this.mvList[this.moveNum] = mv;
        this.movePiece();
        if (this.checked()) {
            this.undoMovePiece();
            return false;
        }
        this.changeSide();
        this.chkList[this.moveNum] = this.checked();
        ++this.moveNum;
        ++this.distance;
        return true;
    }

    public void undoMakeMove() {
        --this.moveNum;
        --this.distance;
        this.changeSide();
        this.undoMovePiece();
    }

    public void nullMove() {
        this.keyList[this.moveNum] = this.zobristKey;
        this.changeSide();
        this.sqEnPassantList[this.moveNum] = 0;
        this.pcList[this.moveNum] = 0;
        this.mvList[this.moveNum] = 0;
        this.specialMoveList[this.moveNum] = false;
        this.chkList[this.moveNum] = false;
        this.castlingBitsList[this.moveNum] = this.castlingBits();
        ++this.moveNum;
        ++this.distance;
    }

    public void undoNullMove() {
        --this.moveNum;
        --this.distance;
        this.changeSide();
    }

    public int fenPiece(char c) {
        switch (c) {
            case 'K': {
                return 0;
            }
            case 'Q': {
                return 1;
            }
            case 'R': {
                return 2;
            }
            case 'B': {
                return 3;
            }
            case 'N': {
                return 4;
            }
            case 'P': {
                return 5;
            }
        }
        return -1;
    }

    public void fromFen(String fen) {
        this.clearBoard();
        int y = 0;
        int x = 4;
        int index = 0;
        if (index == fen.length()) {
            this.setIrrev(0, 0);
            return;
        }
        char c = fen.charAt(index);
        while (c != ' ') {
            if (c == '/') {
                x = 4;
                if (++y > 7) {
                    break;
                }
            } else if (c >= '1' && c <= '8') {
                x += c - 48;
            } else if (c >= 'A' && c <= 'Z') {
                if (x <= 11) {
                    if ((c != 'P' || y != 0 && y != 7) && (pt = this.fenPiece(c)) >= 0) {
                        this.addPiece(Position.COORD_XY(x, y), pt + 8);
                    }
                    ++x;
                }
            } else if (c >= 'a' && c <= 'z' && x <= 11) {
                if ((c != 'p' || y != 0 && y != 7) && (pt = this.fenPiece((char)(c + 65 - 97))) >= 0) {
                    this.addPiece(Position.COORD_XY(x, y), pt + 16);
                }
                ++x;
            }
            if (++index == fen.length()) {
                this.setIrrev(0, 0);
                return;
            }
            c = fen.charAt(index);
        }
        if (++index == fen.length()) {
            this.setIrrev(0, 0);
            return;
        }
        if (this.sdPlayer == (fen.charAt(index) == 'b' ? 0 : 1)) {
            this.changeSide();
        }
        if (++index == fen.length()) {
            this.setIrrev(0, 0);
            return;
        }
        int castlingBits = 0;
        if (++index == fen.length()) {
            this.setIrrev(0, 0);
            return;
        }
        c = fen.charAt(index);
        while (c != ' ') {
            switch (c) {
                case 'K': {
                    if (this.squares[120] != 8 || this.squares[123] != 10) break;
                    ++castlingBits;
                    break;
                }
                case 'Q': {
                    if (this.squares[120] != 8 || this.squares[116] != 10) break;
                    castlingBits += 2;
                    break;
                }
                case 'k': {
                    if (this.squares[8] != 16 || this.squares[11] != 18) break;
                    castlingBits += 4;
                    break;
                }
                case 'q': {
                    if (this.squares[8] != 16 || this.squares[4] != 18) break;
                    castlingBits += 8;
                }
            }
            if (++index == fen.length()) {
                this.setIrrev(castlingBits, 0);
                return;
            }
            c = fen.charAt(index);
        }
        int sqEnPassant = Position.PARSE_COORD(fen, index + 1);
        if (sqEnPassant > 0 && Position.PAWN_EN_PASSANT(sqEnPassant, this.sdPlayer) && this.squares[sqEnPassant - Position.FORWARD_DELTA(this.sdPlayer)] > 0) {
            this.setIrrev(castlingBits, sqEnPassant);
        } else {
            this.setIrrev(castlingBits, 0);
        }
    }

    public String toFen() {
        StringBuffer fen = new StringBuffer();
        for (int y = 0; y <= 7; ++y) {
            int k = 0;
            for (int x = 4; x <= 11; ++x) {
                byte pc = this.squares[Position.COORD_XY(x, y)];
                if (pc > 0) {
                    if (k > 0) {
                        fen.append((char)(48 + k));
                        k = 0;
                    }
                    fen.append(FEN_PIECE.charAt(pc));
                    continue;
                }
                ++k;
            }
            if (k > 0) {
                fen.append((char)(48 + k));
            }
            fen.append('/');
        }
        fen.setCharAt(fen.length() - 1, ' ');
        fen.append(this.sdPlayer == 0 ? (char)'w' : 'b');
        fen.append(' ');
        int castlingBits = this.castlingBits();
        if (castlingBits == 0) {
            fen.append('-');
        } else {
            for (int castling = 0; castling < 4; ++castling) {
                if ((castlingBits & 1 << castling) == 0) continue;
                fen.append(CASTLING_CHAR.charAt(castling));
            }
        }
        fen.append(' ');
        fen.append(this.enPassantSquare() > 0 ? Position.SQUARE_STR(this.enPassantSquare()) : "-");
        return fen.toString();
    }

    public int generateAllMoves(int[] mvs) {
        return this.generateMoves(mvs, null);
    }

    public int generateMoves(int[] mvs, int[] vls) {
        int moves = 0;
        int pcSelfSide = Position.SIDE_TAG(this.sdPlayer);
        int pcOppSide = Position.OPP_SIDE_TAG(this.sdPlayer);
        if (vls == null) {
            for (int i = 0; i < 2; ++i) {
                int castling = (this.sdPlayer << 1) + i;
                if (!this.canCastling(castling)) continue;
                mvs[moves] = Position.MOVE(CASTLING_KING_SRC[castling], CASTLING_KING_DST[castling]);
                ++moves;
            }
        }
        block9: for (int sqSrc = 0; sqSrc < 128; ++sqSrc) {
            byte pcSrc = this.squares[sqSrc];
            if ((pcSrc & pcSelfSide) == 0) continue;
            switch (pcSrc - pcSelfSide) {
                case 0: {
                    byte pcDst;
                    int sqDst;
                    int i;
                    for (i = 0; i < 8; ++i) {
                        sqDst = sqSrc + KING_DELTA[i];
                        if (!Position.IN_BOARD(sqDst)) continue;
                        pcDst = this.squares[sqDst];
                        if (vls == null) {
                            if ((pcDst & pcSelfSide) != 0) continue;
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            ++moves;
                            continue;
                        }
                        if ((pcDst & pcOppSide) == 0) continue;
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        vls[moves] = Position.MVV_LVA(pcDst, 99);
                        ++moves;
                    }
                    continue block9;
                }
                case 1: {
                    byte pcDst;
                    int sqDst;
                    int delta;
                    int i;
                    block11: for (i = 0; i < 8; ++i) {
                        delta = KING_DELTA[i];
                        sqDst = sqSrc + delta;
                        while (Position.IN_BOARD(sqDst)) {
                            pcDst = this.squares[sqDst];
                            if (pcDst == 0) {
                                if (vls == null) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    ++moves;
                                }
                            } else {
                                if ((pcDst & pcOppSide) == 0) continue block11;
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                if (vls != null) {
                                    vls[moves] = Position.MVV_LVA(pcDst, 9);
                                }
                                ++moves;
                                continue block11;
                            }
                            sqDst += delta;
                        }
                    }
                    continue block9;
                }
                case 2: {
                    byte pcDst;
                    int sqDst;
                    int delta;
                    int i;
                    block13: for (i = 0; i < 4; ++i) {
                        delta = ROOK_DELTA[i];
                        sqDst = sqSrc + delta;
                        while (Position.IN_BOARD(sqDst)) {
                            pcDst = this.squares[sqDst];
                            if (pcDst == 0) {
                                if (vls == null) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    ++moves;
                                }
                            } else {
                                if ((pcDst & pcOppSide) == 0) continue block13;
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                if (vls != null) {
                                    vls[moves] = Position.MVV_LVA(pcDst, 5);
                                }
                                ++moves;
                                continue block13;
                            }
                            sqDst += delta;
                        }
                    }
                    continue block9;
                }
                case 3: {
                    byte pcDst;
                    int sqDst;
                    int delta;
                    int i;
                    block15: for (i = 0; i < 4; ++i) {
                        delta = BISHOP_DELTA[i];
                        sqDst = sqSrc + delta;
                        while (Position.IN_BOARD(sqDst)) {
                            pcDst = this.squares[sqDst];
                            if (pcDst == 0) {
                                if (vls == null) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    ++moves;
                                }
                            } else {
                                if ((pcDst & pcOppSide) == 0) continue block15;
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                if (vls != null) {
                                    vls[moves] = Position.MVV_LVA(pcDst, 3);
                                }
                                ++moves;
                                continue block15;
                            }
                            sqDst += delta;
                        }
                    }
                    continue block9;
                }
                case 4: {
                    byte pcDst;
                    int sqDst;
                    int i;
                    for (i = 0; i < 8; ++i) {
                        sqDst = sqSrc + KNIGHT_DELTA[i];
                        if (!Position.IN_BOARD(sqDst)) continue;
                        pcDst = this.squares[sqDst];
                        if (vls == null) {
                            if ((pcDst & pcSelfSide) != 0) continue;
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            ++moves;
                            continue;
                        }
                        if ((pcDst & pcOppSide) == 0) continue;
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        vls[moves] = Position.MVV_LVA(pcDst, 3);
                        ++moves;
                    }
                    continue block9;
                }
                case 5: {
                    int delta = Position.FORWARD_DELTA(this.sdPlayer);
                    int sqDst = sqSrc + delta;
                    if (vls == null) {
                        if (Position.IN_BOARD(sqDst) && this.squares[sqDst] == 0) {
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            ++moves;
                            if (Position.PAWN_INIT(sqSrc, this.sdPlayer) && this.squares[sqDst += delta] == 0) {
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                ++moves;
                            }
                        }
                    } else if (Position.PAWN_PROMOTION(sqDst, this.sdPlayer) && this.squares[sqDst] == 0) {
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        vls[moves] = Position.MVV_LVA(1, 1);
                        ++moves;
                    }
                    int sqTmp = sqSrc + delta;
                    for (int i = -1; i <= 1; i += 2) {
                        sqDst = sqTmp + i;
                        if (!Position.IN_BOARD(sqDst)) continue;
                        byte pcDst = this.squares[sqDst];
                        if (sqDst == this.enPassantSquare()) {
                            pcDst = this.squares[sqDst - delta];
                        }
                        if ((pcDst & pcOppSide) == 0) continue;
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        if (vls != null) {
                            vls[moves] = Position.MVV_LVA(pcDst, 1);
                        }
                        ++moves;
                    }
                    continue block9;
                }
            }
        }
        return moves;
    }

    public boolean legalMove(int mv) {
        int pcSelfSide;
        int sqSrc = Position.SRC(mv);
        byte pcSrc = this.squares[sqSrc];
        if ((pcSrc & (pcSelfSide = Position.SIDE_TAG(this.sdPlayer))) == 0) {
            return false;
        }
        int sqDst = Position.DST(mv);
        byte pcDst = this.squares[sqDst];
        if ((pcDst & pcSelfSide) != 0) {
            return false;
        }
        int pieceType = pcSrc - pcSelfSide;
        switch (pieceType) {
            case 0: {
                if (Position.KING_SPAN(sqSrc, sqDst)) {
                    return true;
                }
                int castling = Position.CASTLING_TYPE(this.sdPlayer, sqSrc, sqDst);
                return CASTLING_KING_DST[castling] == sqDst && this.canCastling(castling);
            }
            case 4: {
                return Position.KNIGHT_SPAN(sqSrc, sqDst);
            }
            case 1: 
            case 2: 
            case 3: {
                int delta;
                switch (Position.SAME_LINE(sqSrc, sqDst)) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (pieceType == 3) {
                            return false;
                        }
                        delta = sqDst < sqSrc ? -1 : 1;
                        break;
                    }
                    case 2: {
                        if (pieceType == 3) {
                            return false;
                        }
                        delta = sqDst < sqSrc ? -16 : 16;
                        break;
                    }
                    case 3: {
                        if (pieceType == 2) {
                            return false;
                        }
                        delta = sqDst < sqSrc ? -15 : 15;
                        break;
                    }
                    case 4: {
                        if (pieceType == 2) {
                            return false;
                        }
                        delta = sqDst < sqSrc ? -17 : 17;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                for (int sqTmp = sqSrc + delta; sqTmp != sqDst; sqTmp += delta) {
                    if (this.squares[sqTmp] <= 0) continue;
                    return false;
                }
                return true;
            }
            case 5: {
                int delta = Position.FORWARD_DELTA(this.sdPlayer);
                int sqTmp = sqSrc + delta;
                if (pcDst != 0 || sqDst == this.enPassantSquare()) {
                    return sqDst == sqTmp - 1 || sqDst == sqTmp + 1;
                }
                return sqDst == sqTmp || sqDst == sqTmp + delta && Position.PAWN_INIT(sqSrc, this.sdPlayer) && this.squares[sqTmp] == 0;
            }
        }
        return false;
    }

    public boolean checked() {
        int pcSelfSide = Position.SIDE_TAG(this.sdPlayer);
        for (int sqSrc = 0; sqSrc < 128; ++sqSrc) {
            if (this.squares[sqSrc] != pcSelfSide + 0) continue;
            return this.checked(sqSrc);
        }
        return false;
    }

    public boolean checked(int sqSrc) {
        byte pcDst;
        int sqDst;
        int delta;
        int sqDst2;
        int i;
        int pcOppSide = Position.OPP_SIDE_TAG(this.sdPlayer);
        int sqTmp = sqSrc + Position.FORWARD_DELTA(this.sdPlayer);
        for (i = -1; i <= 1; i += 2) {
            sqDst2 = sqTmp + i;
            if (!Position.IN_BOARD(sqDst2) || this.squares[sqDst2] != pcOppSide + 5) continue;
            return true;
        }
        for (i = 0; i < 8; ++i) {
            sqDst2 = sqSrc + KING_DELTA[i];
            if (!Position.IN_BOARD(sqDst2) || this.squares[sqDst2] != pcOppSide + 0) continue;
            return true;
        }
        for (i = 0; i < 8; ++i) {
            sqDst2 = sqSrc + KNIGHT_DELTA[i];
            if (!Position.IN_BOARD(sqDst2) || this.squares[sqDst2] != pcOppSide + 4) continue;
            return true;
        }
        block3: for (i = 0; i < 4; ++i) {
            delta = BISHOP_DELTA[i];
            sqDst = sqSrc + delta;
            while (Position.IN_BOARD(sqDst)) {
                pcDst = this.squares[sqDst];
                if (pcDst > 0) {
                    if (pcDst != pcOppSide + 3 && pcDst != pcOppSide + 1) continue block3;
                    return true;
                }
                sqDst += delta;
            }
        }
        block5: for (i = 0; i < 4; ++i) {
            delta = ROOK_DELTA[i];
            sqDst = sqSrc + delta;
            while (Position.IN_BOARD(sqDst)) {
                pcDst = this.squares[sqDst];
                if (pcDst > 0) {
                    if (pcDst != pcOppSide + 2 && pcDst != pcOppSide + 1) continue block5;
                    return true;
                }
                sqDst += delta;
            }
        }
        return false;
    }

    public boolean isMate() {
        int[] mvs = new int[128];
        int moves = this.generateAllMoves(mvs);
        for (int i = 0; i < moves; ++i) {
            if (!this.makeMove(mvs[i])) continue;
            this.undoMakeMove();
            return false;
        }
        return true;
    }

    public int drawValue() {
        return (this.distance & 1) == 0 ? -50 : 50;
    }

    public int checkmateValue() {
        return this.distance - 10000;
    }

    public int mateValue() {
        return this.inCheck() ? this.checkmateValue() : this.drawValue();
    }

    public int material() {
        return (this.sdPlayer == 0 ? this.vlWhite - this.vlBlack : this.vlBlack - this.vlWhite) + 10;
    }

    public boolean nullOkay() {
        return (this.sdPlayer == 0 ? this.vlWhite : this.vlBlack) > 500;
    }

    public boolean nullSafe() {
        return (this.sdPlayer == 0 ? this.vlWhite : this.vlBlack) > 1000;
    }

    public boolean isRep() {
        return this.isRep(1);
    }

    public boolean isRep(int recur_) {
        int recur = recur_;
        boolean selfSide = false;
        int index = this.moveNum - 1;
        while (this.mvList[index] > 0 && this.pcList[index] == 0) {
            if (selfSide && this.keyList[index] == this.zobristKey && --recur == 0) {
                return true;
            }
            selfSide = !selfSide;
            --index;
        }
        return false;
    }

    public int bookMove() {
        if (bookSize == 0) {
            return 0;
        }
        int lock = this.zobristLock >>> 1;
        int index = Util.binarySearch(lock, bookLock, 0, bookSize);
        if (index < 0) {
            return 0;
        }
        --index;
        while (index >= 0 && bookLock[index] == lock) {
            --index;
        }
        int[] mvs = new int[128];
        int[] vls = new int[128];
        int value = 0;
        int moves = 0;
        ++index;
        while (index < bookSize && bookLock[index] == lock) {
            int mv = 0xFFFF & bookMove[index];
            if (this.legalMove(mv)) {
                mvs[moves] = mv;
                vls[moves] = bookValue[index];
                value += vls[moves];
                if (++moves == 128) break;
            }
            ++index;
        }
        if (value == 0) {
            return 0;
        }
        value = Math.abs(random.nextInt()) % value;
        for (index = 0; index < moves && (value -= vls[index]) >= 0; ++index) {
        }
        return mvs[index];
    }

    public int historyIndex(int mv) {
        return (this.squares[Position.SRC(mv)] - 8 << 7) + Position.DST(mv);
    }

    public void printBoard() {
        this.printBoard(System.out);
    }

    public void printBoard(PrintStream out) {
        for (int y = 0; y <= 7; ++y) {
            out.print((char)(56 - y));
            out.print('|');
            for (int x = 4; x <= 11; ++x) {
                byte pc = this.squares[Position.COORD_XY(x, y)];
                if (pc > 0) {
                    if (pc < 16) {
                        out.print(PIECE_STRING.charAt(pc - 8));
                    } else {
                        out.print((char)(PIECE_STRING.charAt(pc - 16) - 65 + 97));
                    }
                } else {
                    out.print('.');
                }
                out.print(' ');
            }
            out.println();
        }
        out.println(" +----------------");
        out.println("  a b c d e f g h");
    }

    static {
        PreGen_zobristKeyTable = new int[12][128];
        PreGen_zobristLockTable = new int[12][128];
        random = new Random();
        bookSize = 0;
        bookLock = new int[16384];
        bookMove = new short[16384];
        bookValue = new short[16384];
        Util.RC4 rc4 = new Util.RC4(new byte[]{0});
        PreGen_zobristKeyPlayer = rc4.nextLong();
        rc4.nextLong();
        PreGen_zobristLockPlayer = rc4.nextLong();
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 128; ++j) {
                Position.PreGen_zobristKeyTable[i][j] = rc4.nextLong();
                rc4.nextLong();
                Position.PreGen_zobristLockTable[i][j] = rc4.nextLong();
            }
        }
        InputStream in = rc4.getClass().getResourceAsStream("/assets/touhou_little_maid/book/wchess/BOOK.DAT");
        if (in != null) {
            try {
                while (bookSize < 16384) {
                    Position.bookLock[Position.bookSize] = Util.readInt(in) >>> 1;
                    Position.bookMove[Position.bookSize] = (short)Util.readShort(in);
                    Position.bookValue[Position.bookSize] = (short)Util.readShort(in);
                    ++bookSize;
                }
            }
            catch (Exception j) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

