/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.inner;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.EntityBaseAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.MaidArmorAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.MaidExtraAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.TacCompat;
import java.util.HashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public final class MaidBaseAnimation {
    private static final float[] FIXED_HAND_ROTATION = new float[]{0.0f, 0.0f, 0.0f};

    public static void init() {
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/arm/default.js"), MaidBaseAnimation.getArmDefault());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/arm/swing.js"), MaidBaseAnimation.getArmSwing());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/beg.js"), MaidBaseAnimation.getHeadBeg());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/blink.js"), MaidBaseAnimation.getHeadBlink());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/default.js"), MaidBaseAnimation.getHeadDefault());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/music_shake.js"), MaidBaseAnimation.getHeadMusicShake());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/ear_shake.js"), MaidBaseAnimation.getEarShake());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/ear_beg_shake.js"), MaidBaseAnimation.getEarBegShake());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/hair_swing.js"), MaidBaseAnimation.getHairSwing());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/head/hair_ponytail_swing.js"), MaidBaseAnimation.getHairPonytailSwing());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/leg/default.js"), MaidBaseAnimation.getLegDefault());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/sit/default.js"), MaidBaseAnimation.getSitDefault());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/sit/no_leg.js"), MaidBaseAnimation.getSitNoLeg());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/sit/skirt_hidden.js"), MaidBaseAnimation.getSitSkirtHidden());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/sit/skirt_rotation.js"), MaidBaseAnimation.getSitSkirtRotation());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/sit/skirt_rotation_swing.js"), MaidBaseAnimation.getSitSkirtRotationSwing());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/status/backpack.js"), MaidBaseAnimation.getStatusBackpack());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/status/backpack_level.js"), MaidBaseAnimation.getStatusBackpackLevel());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/status/sasimono.js"), MaidBaseAnimation.getStatusSasimono());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/tail/default.js"), MaidBaseAnimation.getTailDefault());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/wing/default.js"), MaidBaseAnimation.getWingDefault());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid/default/sleep/default.js"), MaidBaseAnimation.getSleepDefault());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/maid.default.js"), MaidBaseAnimation.getMaidDefault());
    }

    public static IAnimation<class_1308> getHeadDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper hat;
                ModelRendererWrapper head = modelMap.get("head");
                if (head != null) {
                    head.setRotateAngleX(headPitch * ((float)Math.PI / 180));
                    head.setRotateAngleY(netHeadYaw * ((float)Math.PI / 180));
                    if (maid.method_6113()) {
                        head.setRotateAngleX(0.2617994f);
                    }
                }
                if ((hat = modelMap.get("hat")) != null) {
                    hat.setHidden(maid.method_6113());
                }
            }
        };
    }

    public static IAnimation<class_1308> getHeadBlink() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                float remainder;
                ModelRendererWrapper blink = modelMap.get("blink");
                ModelRendererWrapper blink2 = modelMap.get("blink2");
                if (blink != null) {
                    if (maid.method_6113()) {
                        blink.setHidden(false);
                        return;
                    }
                    remainder = (ageInTicks + (float)(Math.abs(maid.method_5667().getLeastSignificantBits()) % 10L)) % 60.0f;
                    blink.setHidden(!(55.0f < remainder) || !(remainder < 60.0f));
                }
                if (blink2 != null) {
                    if (maid.method_6113()) {
                        blink2.setHidden(false);
                        return;
                    }
                    remainder = (ageInTicks + (float)(Math.abs(maid.method_5667().getLeastSignificantBits()) % 10L)) % 60.0f;
                    blink2.setHidden(!(55.0f < remainder) || !(remainder < 60.0f));
                }
            }
        };
    }

    public static IAnimation<class_1308> getHeadBeg() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper head = modelMap.get("head");
                ModelRendererWrapper ahoge = modelMap.get("ahoge");
                ModelRendererWrapper begShow = modelMap.get("begShow");
                if (maid.isBegging()) {
                    if (head != null) {
                        head.setRotateAngleZ(0.139f);
                    }
                    if (ahoge != null) {
                        ahoge.setRotateAngleX((float)(Math.cos((double)ageInTicks * 1.0) * 0.05) + ahoge.getInitRotateAngleX());
                        ahoge.setRotateAngleZ((float)(Math.sin((double)ageInTicks * 1.0) * 0.05) + ahoge.getInitRotateAngleZ());
                    }
                    if (begShow != null) {
                        begShow.setHidden(false);
                    }
                } else {
                    if (head != null) {
                        head.setRotateAngleZ(head.getInitRotateAngleZ());
                    }
                    if (ahoge != null) {
                        ahoge.setRotateAngleZ(ahoge.getInitRotateAngleZ());
                    }
                    if (begShow != null) {
                        begShow.setHidden(true);
                    }
                }
            }
        };
    }

    public static IAnimation<class_1308> getHeadMusicShake() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper head = modelMap.get("head");
                if (head != null && MaidBaseAnimation.isPortableAudioPlay()) {
                    head.setRotateAngleZ((float)(Math.cos((double)ageInTicks * 0.4) * 0.06) + head.getInitRotateAngleZ());
                }
            }
        };
    }

    public static IAnimation<class_1308> getHairPonytailSwing() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper hairPonytailSwing = modelMap.get("hairPonytailSwing");
                if (hairPonytailSwing != null) {
                    float rotationZ = (float)Math.sin((double)ageInTicks * 0.05) * 0.06f;
                    hairPonytailSwing.setRotateAngleZ(rotationZ + hairPonytailSwing.getInitRotateAngleZ());
                }
            }
        };
    }

    public static IAnimation<class_1308> getHairSwing() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper hairLeftSwing = modelMap.get("hairLeftSwing");
                ModelRendererWrapper hairRightSwing = modelMap.get("hairRightSwing");
                float rotationZ = (float)Math.sin((double)ageInTicks * 0.05) * 0.04f;
                if (hairLeftSwing != null) {
                    hairLeftSwing.setRotateAngleZ(hairLeftSwing.getInitRotateAngleZ() + rotationZ);
                }
                if (hairRightSwing != null) {
                    hairRightSwing.setRotateAngleZ(hairRightSwing.getInitRotateAngleZ() - rotationZ);
                }
            }
        };
    }

    public static IAnimation<class_1308> getEarShake() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper earLeftShake = modelMap.get("earLeftShake");
                ModelRendererWrapper earRightShake = modelMap.get("earRightShake");
                float time = (ageInTicks + (float)(Math.abs(maid.method_5667().getLeastSignificantBits()) % 10L)) % 40.0f;
                if ((double)time < Math.PI * 4) {
                    float rotationZ = (float)Math.abs(Math.sin((double)time * 0.25)) * 0.4f;
                    if (earLeftShake != null) {
                        earLeftShake.setRotateAngleZ(earLeftShake.getInitRotateAngleZ() + rotationZ);
                    }
                    if (earRightShake != null) {
                        earRightShake.setRotateAngleZ(earRightShake.getInitRotateAngleZ() - rotationZ);
                    }
                } else {
                    if (earLeftShake != null) {
                        earLeftShake.setRotateAngleZ(earLeftShake.getInitRotateAngleZ());
                    }
                    if (earRightShake != null) {
                        earRightShake.setRotateAngleZ(earRightShake.getInitRotateAngleZ());
                    }
                }
            }
        };
    }

    public static IAnimation<class_1308> getEarBegShake() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper earLeftShake = modelMap.get("earLeftBegShake");
                ModelRendererWrapper earRightShake = modelMap.get("earRightBegShake");
                float time = (ageInTicks + (float)(Math.abs(mob.method_5667().getLeastSignificantBits()) % 10L)) % 40.0f;
                if (maid.isBegging() && (double)time < Math.PI * 4) {
                    float rotationZ = (float)Math.abs(Math.sin((double)time * 0.25)) * 0.4f;
                    if (earLeftShake != null) {
                        earLeftShake.setRotateAngleZ(earLeftShake.getInitRotateAngleZ() + rotationZ);
                    }
                    if (earRightShake != null) {
                        earRightShake.setRotateAngleZ(earRightShake.getInitRotateAngleZ() - rotationZ);
                    }
                } else {
                    if (earLeftShake != null) {
                        earLeftShake.setRotateAngleZ(earLeftShake.getInitRotateAngleZ());
                    }
                    if (earRightShake != null) {
                        earRightShake.setRotateAngleZ(earRightShake.getInitRotateAngleZ());
                    }
                }
            }
        };
    }

    public static IAnimation<class_1308> getLegDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                boolean isFarm;
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper legLeft = modelMap.get("legLeft");
                ModelRendererWrapper legRight = modelMap.get("legRight");
                boolean bl = isFarm = "farm".equals(maid.getTask().getUid().method_12832()) && maid.asEntity().field_6279 > 0;
                if (isFarm) {
                    GlWrapper.translate(0.0, 0.0713625, -0.35876875);
                    GlWrapper.rotate(22.5, 1.0, 0.0, 0.0);
                }
                if (legLeft != null) {
                    double leftRad = Math.cos((double)limbSwing * 0.67) * 0.3 * (double)limbSwingAmount;
                    if (isFarm) {
                        leftRad -= 0.3927;
                    }
                    legLeft.setRotateAngleX((float)leftRad);
                    legLeft.setRotateAngleY(legLeft.getInitRotateAngleY());
                    legLeft.setRotateAngleZ(legLeft.getInitRotateAngleZ());
                }
                if (legRight != null) {
                    double rightRad = -Math.cos((double)limbSwing * 0.67) * 0.3 * (double)limbSwingAmount;
                    if (isFarm) {
                        rightRad -= 0.3927;
                    }
                    legRight.setRotateAngleX((float)rightRad);
                    legRight.setRotateAngleY(legRight.getInitRotateAngleY());
                    legRight.setRotateAngleZ(legRight.getInitRotateAngleZ());
                }
            }
        };
    }

    public static IAnimation<class_1308> getArmDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                float[] rotation;
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper armLeft = modelMap.get("armLeft");
                ModelRendererWrapper armRight = modelMap.get("armRight");
                double f1 = 1.0 - Math.pow(1.0 - (double)mob.field_6251, 4.0);
                double f2 = Math.sin(f1 * Math.PI);
                double f3 = Math.sin((double)mob.field_6251 * Math.PI) * -0.7 * 0.75;
                if (armLeft != null) {
                    if (maid.isSitInJoyBlock()) {
                        armLeft.setRotateAngleX(-1.3f);
                    } else if (MaidBaseAnimation.isHoldTrolley()) {
                        armLeft.setRotateAngleX(0.5f);
                        armLeft.setRotateAngleY(armLeft.getInitRotateAngleY());
                        armLeft.setRotateAngleZ(-0.395f);
                    } else if (MaidBaseAnimation.isHoldVehicle()) {
                        rotation = MaidBaseAnimation.getLeftHandRotation();
                        armLeft.setRotateAngleX(rotation[0]);
                        armLeft.setRotateAngleY(rotation[1]);
                        armLeft.setRotateAngleZ(rotation[2]);
                    } else {
                        armLeft.setRotateAngleX((float)(-Math.cos((double)limbSwing * 0.67) * 0.7 * (double)limbSwingAmount));
                        armLeft.setRotateAngleY(armLeft.getInitRotateAngleY());
                        armLeft.setRotateAngleZ((float)(Math.cos((double)ageInTicks * 0.05) * 0.05 + (double)armLeft.getInitRotateAngleZ()));
                        if ((double)mob.field_6251 > 0.0 && MaidBaseAnimation.isSwingLeftHand(mob)) {
                            armLeft.setRotateAngleX((float)((double)armLeft.getRotateAngleX() - (f2 * 1.2 + f3)));
                            armLeft.setRotateAngleZ((float)((double)armLeft.getRotateAngleZ() + Math.sin((double)mob.field_6251 * Math.PI) * -0.4));
                        }
                        if (mob.method_6115() && mob.method_6058() == class_1268.field_5810) {
                            armLeft.setRotateAngleX((float)((double)armLeft.getInitRotateAngleX() - 1.3962634015954636));
                            armLeft.setRotateAngleY((float)((double)armLeft.getInitRotateAngleY() + 0.4363323129985824));
                        }
                    }
                }
                if (armRight != null) {
                    if (maid.isSitInJoyBlock()) {
                        armRight.setRotateAngleX(-1.3f);
                    } else if (MaidBaseAnimation.isHoldVehicle()) {
                        rotation = MaidBaseAnimation.getRightHandRotation();
                        armRight.setRotateAngleX(rotation[0]);
                        armRight.setRotateAngleY(rotation[1]);
                        armRight.setRotateAngleZ(rotation[2]);
                    } else {
                        if (TacCompat.onHoldGun(maid, armLeft, armRight)) {
                            return;
                        }
                        armRight.setRotateAngleX((float)(Math.cos((double)limbSwing * 0.67) * 0.7 * (double)limbSwingAmount));
                        armRight.setRotateAngleY(armRight.getInitRotateAngleY());
                        armRight.setRotateAngleZ((float)(-Math.cos((double)ageInTicks * 0.05) * 0.05 + (double)armRight.getInitRotateAngleZ()));
                        if ((double)mob.field_6251 > 0.0 && !MaidBaseAnimation.isSwingLeftHand(mob)) {
                            armRight.setRotateAngleX((float)((double)armRight.getRotateAngleX() - (f2 * 1.2 + f3)));
                            armRight.setRotateAngleZ((float)((double)armRight.getRotateAngleZ() + Math.sin((double)mob.field_6251 * Math.PI) * -0.4));
                        }
                        if (mob.method_6115() && mob.method_6058() == class_1268.field_5808) {
                            armRight.setRotateAngleX((float)((double)armRight.getInitRotateAngleX() - 1.3962634015954636));
                            armRight.setRotateAngleY((float)((double)armRight.getInitRotateAngleY() - 0.3490658503988659));
                        }
                    }
                }
            }
        };
    }

    public static IAnimation<class_1308> getArmSwing() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper armLeft = modelMap.get("armLeft");
                ModelRendererWrapper armRight = modelMap.get("armRight");
                class_1308 entity = maid.asEntity();
                if (!entity.method_6047().method_7960() && maid.isSwingingArms() && !TacCompat.onHoldGun(maid, armLeft, armRight)) {
                    if (armLeft != null) {
                        armLeft.setRotateAngleX(-1.396f);
                        armLeft.setRotateAngleY(0.785f);
                    }
                    if (armRight != null) {
                        armRight.setRotateAngleX(-1.396f);
                        armRight.setRotateAngleY(-0.174f);
                    }
                }
            }
        };
    }

    public static IAnimation<class_1308> getSitDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper head = modelMap.get("head");
                ModelRendererWrapper legLeft = modelMap.get("legLeft");
                ModelRendererWrapper legRight = modelMap.get("legRight");
                ModelRendererWrapper armLeft = modelMap.get("armLeft");
                ModelRendererWrapper armRight = modelMap.get("armRight");
                if (head != null) {
                    head.setOffsetY(0.0f);
                }
                if (MaidBaseAnimation.isPassengerMarisaBroom(mob)) {
                    MaidBaseAnimation.ridingBroomPosture(head, armLeft, armRight, legLeft, legRight);
                } else if (mob.method_5765()) {
                    MaidBaseAnimation.ridingPosture(legLeft, legRight);
                } else if (maid.isMaidInSittingPose()) {
                    MaidBaseAnimation.sittingPosture(armLeft, armRight, legLeft, legRight);
                }
            }
        };
    }

    public static IAnimation<class_1308> getSitNoLeg() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper head = modelMap.get("head");
                ModelRendererWrapper legLeft = modelMap.get("legLeft");
                ModelRendererWrapper legRight = modelMap.get("legRight");
                ModelRendererWrapper armLeft = modelMap.get("armLeft");
                ModelRendererWrapper armRight = modelMap.get("armRight");
                if (head != null) {
                    head.setOffsetY(0.0f);
                }
                if (MaidBaseAnimation.isPassengerMarisaBroom(mob)) {
                    MaidBaseAnimation.ridingBroomPosture(head, armLeft, armRight, legLeft, legRight);
                } else if (mob.method_5765()) {
                    MaidBaseAnimation.ridingPosture(legLeft, legRight);
                } else if (maid.isMaidInSittingPose()) {
                    MaidBaseAnimation.sittingNoLegPosture(armLeft, armRight);
                }
            }
        };
    }

    public static IAnimation<class_1308> getSitSkirtHidden() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper reverseSittingHiddenSkirt;
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper sittingHiddenSkirt = modelMap.get("sittingHiddenSkirt");
                if (sittingHiddenSkirt != null) {
                    sittingHiddenSkirt.setHidden(MaidBaseAnimation.isPassengerMarisaBroom(mob) || mob.method_5765() || maid.isMaidInSittingPose());
                }
                if ((reverseSittingHiddenSkirt = modelMap.get("_sittingHiddenSkirt")) != null) {
                    reverseSittingHiddenSkirt.setHidden(!MaidBaseAnimation.isPassengerMarisaBroom(mob) && !mob.method_5765() && !maid.isMaidInSittingPose());
                }
            }
        };
    }

    public static IAnimation<class_1308> getSitSkirtRotation() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper sittingRotationSkirt = modelMap.get("sittingRotationSkirt");
                if (sittingRotationSkirt != null) {
                    if (MaidBaseAnimation.isPassengerMarisaBroom(mob) || mob.method_5765() || maid.isMaidInSittingPose()) {
                        sittingRotationSkirt.setRotateAngleX(-0.567f);
                    } else {
                        sittingRotationSkirt.setRotateAngleX(sittingRotationSkirt.getInitRotateAngleX());
                    }
                }
            }
        };
    }

    public static IAnimation<class_1308> getSitSkirtRotationSwing() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper sittingRotationSwingSkirt = modelMap.get("sittingRotationSwingSkirt");
                if (sittingRotationSwingSkirt != null) {
                    if (MaidBaseAnimation.isPassengerMarisaBroom(mob) || mob.method_5765() || maid.isMaidInSittingPose()) {
                        sittingRotationSwingSkirt.setRotateAngleX(-0.567f);
                        sittingRotationSwingSkirt.setRotateAngleZ(sittingRotationSwingSkirt.getInitRotateAngleZ());
                    } else {
                        sittingRotationSwingSkirt.setRotateAngleX(sittingRotationSwingSkirt.getInitRotateAngleX());
                        float rotationZ = (float)Math.sin((double)ageInTicks * 0.05) * 0.03f;
                        sittingRotationSwingSkirt.setRotateAngleZ(sittingRotationSwingSkirt.getInitRotateAngleZ() + rotationZ);
                    }
                }
            }
        };
    }

    public static IAnimation<class_1308> getWingDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper wingLeft = modelMap.get("wingLeft");
                ModelRendererWrapper wingRight = modelMap.get("wingRight");
                if (wingLeft != null) {
                    wingLeft.setRotateAngleY((float)(-Math.cos((double)ageInTicks * 0.3) * 0.2 + (double)wingLeft.getInitRotateAngleY()));
                    wingLeft.setHidden(maid.method_6113());
                }
                if (wingRight != null) {
                    wingRight.setRotateAngleY((float)(Math.cos((double)ageInTicks * 0.3) * 0.2 + (double)wingRight.getInitRotateAngleY()));
                    wingRight.setHidden(maid.method_6113());
                }
            }
        };
    }

    public static IAnimation<class_1308> getSleepDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper sleepHide = modelMap.get("sleepHide");
                ModelRendererWrapper sleepShow = modelMap.get("sleepShow");
                if (sleepHide != null) {
                    sleepHide.setHidden(maid.method_6113());
                }
                if (sleepShow != null) {
                    sleepShow.setHidden(!maid.method_6113());
                }
            }
        };
    }

    public static IAnimation<class_1308> getStatusBackpack() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper backpackShow = modelMap.get("backpackShow");
                ModelRendererWrapper backpackHidden = modelMap.get("backpackHidden");
                if (backpackShow != null) {
                    backpackShow.setHidden(!maid.hasBackpack());
                }
                if (backpackHidden != null) {
                    backpackHidden.setHidden(maid.hasBackpack());
                }
            }
        };
    }

    @Deprecated
    public static IAnimation<class_1308> getStatusBackpackLevel() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
            }
        };
    }

    public static IAnimation<class_1308> getStatusSasimono() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 mob, HashMap<String, ModelRendererWrapper> modelMap) {
                IMaid maid = IMaid.convert(mob);
                if (maid == null) {
                    return;
                }
                ModelRendererWrapper sasimonoShow = modelMap.get("sasimonoShow");
                ModelRendererWrapper sasimonoHidden = modelMap.get("sasimonoHidden");
                if (sasimonoShow != null) {
                    sasimonoShow.setHidden(!maid.hasSasimono());
                }
                if (sasimonoHidden != null) {
                    sasimonoHidden.setHidden(maid.hasSasimono());
                }
            }
        };
    }

    public static IAnimation<class_1308> getTailDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper tail = modelMap.get("tail");
                if (tail != null) {
                    tail.setRotateAngleX((float)(Math.sin((double)ageInTicks * 0.2) * 0.05) + tail.getInitRotateAngleX());
                    tail.setRotateAngleZ((float)(Math.cos((double)ageInTicks * 0.2) * 0.1) + tail.getInitRotateAngleZ());
                    tail.setHidden(maid.method_6113());
                }
            }
        };
    }

    public static IAnimation<class_1308> getMaidDefault() {
        return new IAnimation<class_1308>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, class_1308 maid, HashMap<String, ModelRendererWrapper> modelMap) {
                MaidBaseAnimation.getHeadDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getHeadBlink().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getHeadBeg().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getHeadMusicShake().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getLegDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getArmDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getArmSwing().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidExtraAnimation.getArmVertical().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getSitDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidArmorAnimation.getArmorDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidArmorAnimation.getArmorReverse().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getWingDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getTailDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                MaidBaseAnimation.getSitSkirtRotation().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, maid, modelMap);
                EntityBaseAnimation.getBaseFloatDefault().setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, (class_1309)maid, modelMap);
            }
        };
    }

    private static void ridingPosture(ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        if (legLeft != null) {
            legLeft.setRotateAngleX(-1.134f);
            legLeft.setRotateAngleZ(-0.262f);
        }
        if (legRight != null) {
            legRight.setRotateAngleX(-1.134f);
            legRight.setRotateAngleZ(0.262f);
        }
        GlWrapper.translate(0.0, 0.3, 0.0);
    }

    private static void sittingPosture(ModelRendererWrapper armLeft, ModelRendererWrapper armRight, ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        if (armLeft != null) {
            armLeft.setRotateAngleX(-0.798f);
            armLeft.setRotateAngleZ(0.274f);
        }
        if (armRight != null) {
            armRight.setRotateAngleX(-0.798f);
            armRight.setRotateAngleZ(-0.274f);
        }
        MaidBaseAnimation.ridingPosture(legLeft, legRight);
    }

    private static void sittingNoLegPosture(ModelRendererWrapper armLeft, ModelRendererWrapper armRight) {
        if (armLeft != null) {
            armLeft.setRotateAngleX(-0.798f);
            armLeft.setRotateAngleZ(0.274f);
        }
        if (armRight != null) {
            armRight.setRotateAngleX(-0.798f);
            armRight.setRotateAngleZ(-0.274f);
        }
    }

    private static void ridingBroomPosture(ModelRendererWrapper head, ModelRendererWrapper armLeft, ModelRendererWrapper armRight, ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        MaidBaseAnimation.sittingPosture(armLeft, armRight, legLeft, legRight);
        if (head != null) {
            head.setRotateAngleX((float)((double)head.getRotateAngleX() - 0.5235987755982988));
            head.setOffsetY(0.0625f);
        }
        GlWrapper.rotate(30.0, 1.0, 0.0, 0.0);
        GlWrapper.translate(0.0, -0.4, -0.3);
    }

    private static boolean isSwingLeftHand(class_1308 maid) {
        return maid.field_6266 == class_1268.field_5810;
    }

    @Deprecated
    public static boolean isPassengerMarisaBroom(class_1308 maid) {
        return false;
    }

    @Deprecated
    private static boolean isPortableAudioPlay() {
        return false;
    }

    @Deprecated
    private static boolean isHoldTrolley() {
        return false;
    }

    @Deprecated
    private static boolean isHoldVehicle() {
        return false;
    }

    @Deprecated
    private static float[] getLeftHandRotation() {
        return FIXED_HAND_ROTATION;
    }

    @Deprecated
    private static float[] getRightHandRotation() {
        return FIXED_HAND_ROTATION;
    }
}

