/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.CacheIconTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.IconCache;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_638;
import org.apache.commons.lang3.time.StopWatch;

@Environment(value=EnvType.CLIENT)
public class CacheScreen<T extends class_1309, E extends IModelInfo>
extends class_437 {
    protected final class_437 parent;
    protected final class_1299<T> entityType;
    protected final Queue<E> modelInfos;
    protected final EntityRender<T, E> entityRender;
    protected final int totalCount;
    protected final StopWatch stopWatch;

    public CacheScreen(class_437 parent, class_1299<T> entityType, Queue<E> modelInfos, EntityRender<T, E> entityRender) {
        super((class_2561)class_2561.method_43470((String)"Cache Screen"));
        this.parent = parent;
        this.entityType = entityType;
        this.modelInfos = modelInfos;
        this.entityRender = entityRender;
        this.totalCount = modelInfos.size();
        this.stopWatch = StopWatch.createStarted();
    }

    private void drawEntity(class_332 graphics, int posX, int posY, E modelInfo, int scaleModified) {
        class_1309 entity;
        class_638 world = Screens.getClient((class_437)this).field_1687;
        if (world == null) {
            return;
        }
        try {
            entity = (class_1309)EntityCacheUtil.ENTITY_CACHE.get(this.entityType, () -> this.lambda$drawEntity$0((class_1937)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.fillInStackTrace();
            return;
        }
        this.entityRender.render(graphics, posX, posY, modelInfo, scaleModified, entity);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.modelInfos.isEmpty()) {
            this.stopWatch.stop();
            double timeCost = (double)this.stopWatch.getTime(TimeUnit.MILLISECONDS) / 1000.0;
            TouhouLittleMaid.LOGGER.info("Cache icon time: {} seconds", (Object)timeCost);
            class_310.method_1551().method_1507(this.parent);
            return;
        }
        graphics.method_51448().method_22903();
        for (int i = 0; i < 5; ++i) {
            if (this.modelInfos.isEmpty()) {
                return;
            }
            graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            this.doCacheIcon(graphics);
        }
        graphics.method_51448().method_22909();
        int finishSize = this.totalCount - this.modelInfos.size();
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.touhou_little_maid.cache_screen.progress", (Object[])new Object[]{finishSize, this.totalCount}), this.field_22789 / 2, this.field_22790 - 42, 0xFFFFFF);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.cache_screen.desc"), this.field_22789 / 2, this.field_22790 - 30, 0xFFFFFF);
    }

    protected void doCacheIcon(class_332 graphics) {
        IModelInfo modelInfo = (IModelInfo)this.modelInfos.poll();
        if (modelInfo != null) {
            double guiScale = class_310.method_1551().method_22683().method_4495();
            int scaleModified = (int)Math.ceil(256.0 / guiScale);
            graphics.method_25294(0, 0, scaleModified, scaleModified + 2, -16711936);
            this.drawEntity(graphics, 0, 0, modelInfo, scaleModified);
            class_1011 nativeImage = IconCache.exportImageFromScreenshot(256, -16711936);
            class_2960 modelId = modelInfo.getModelId();
            CacheIconTexture cacheIconTexture = new CacheIconTexture(modelId, nativeImage);
            class_310.method_1551().method_1531().method_4616(modelInfo.getCacheIconId(), (class_1044)cacheIconTexture);
        }
    }

    private /* synthetic */ class_1297 lambda$drawEntity$0(class_1937 world) throws Exception {
        return this.entityType.method_5883(world);
    }

    public static interface EntityRender<T extends class_1309, E extends IModelInfo> {
        public void render(class_332 var1, int var2, int var3, E var4, int var5, T var6);
    }
}

