/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task.MaidTaskConfigGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MonsterListButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetAttackListMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class AttackTaskConfigGui
extends MaidTaskConfigGui<TaskConfigContainer> {
    private static final class_2960 BG = new class_2960("touhou_little_maid", "textures/gui/attack_task_config.png");
    private final Map<class_2960, MonsterType> attackGroups = Objects.requireNonNullElse(this.getMaid().getData(InitTaskData.ATTACK_LIST), AttackListData.empty()).attackGroups();
    private final List<class_2960> attackGroupsKey = Lists.newArrayList();
    private class_342 inputField;
    private int page = 0;

    public AttackTaskConfigGui(TaskConfigContainer screenContainer, class_1661 inv, class_2561 titleIn) {
        super(screenContainer, inv, titleIn);
        this.sortKey();
    }

    private void sortKey() {
        this.attackGroupsKey.clear();
        ArrayList hostile = Lists.newArrayList();
        ArrayList neutral = Lists.newArrayList();
        ArrayList friendly = Lists.newArrayList();
        for (class_2960 id : this.attackGroups.keySet()) {
            if (this.attackGroups.get(id) == MonsterType.HOSTILE) {
                hostile.add(id);
            }
            if (this.attackGroups.get(id) == MonsterType.NEUTRAL) {
                neutral.add(id);
            }
            if (this.attackGroups.get(id) != MonsterType.FRIENDLY) continue;
            friendly.add(id);
        }
        this.attackGroupsKey.addAll(hostile);
        this.attackGroupsKey.addAll(neutral);
        this.attackGroupsKey.addAll(friendly);
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
    }

    @Override
    protected void initAdditionWidgets() {
        int startLeft = this.field_2776 + 87;
        int startTop = this.field_2800 + 36;
        this.inputField = new class_342(this.field_22793, startLeft, startTop, 117, 16, (class_2561)class_2561.method_43470((String)"Monster List"));
        this.inputField.method_1880(256);
        this.method_25429((class_364)this.inputField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.monster_type.add"), b -> this.addMonsterType()).method_46433(startLeft + 119, startTop - 1).method_46437(44, 18).method_46431());
        this.method_37063((class_364)new TouhouImageButton(startLeft + 121, startTop + 20, 5, 9, 0, 176, 9, BG, b -> {
            --this.page;
            this.page = class_3532.method_15340((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
            this.method_25426();
        }));
        this.method_37063((class_364)new TouhouImageButton(startLeft + 156, startTop + 20, 5, 9, 5, 176, 9, BG, b -> {
            ++this.page;
            this.page = class_3532.method_15340((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
            this.method_25426();
        }));
        for (int i = 0; i < 7; ++i) {
            int index = this.page * 7 + i;
            if (index >= this.attackGroupsKey.size()) {
                return;
            }
            class_2960 id = this.attackGroupsKey.get(index);
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
            class_2561 name = type.method_5897();
            int yOffset = startTop + 31 + 13 * i;
            this.method_37063((class_364)new MonsterListButton(name, startLeft - 1, yOffset, id, this));
        }
    }

    private void addMonsterType() {
        String value = this.inputField.method_1882();
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (!class_2960.method_20207((String)value)) {
            return;
        }
        class_2960 id = class_2960.method_12829((String)value);
        if (id != null && class_7923.field_41177.method_10250(id)) {
            this.attackGroups.put(id, MonsterType.NEUTRAL);
            this.sortKey();
            super.method_25426();
        }
    }

    public void removeMonsterType(class_2960 id) {
        this.attackGroups.remove(id);
        this.sortKey();
        super.method_25426();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String value = this.inputField.method_1882();
        super.method_25410(minecraft, width, height);
        this.inputField.method_1852(value);
    }

    @Override
    protected void renderAddition(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.inputField.method_25394(graphics, mouseX, mouseY, partialTicks);
        class_5250 pageText = class_2561.method_43470((String)String.format("%d/%d", this.page + 1, (this.attackGroupsKey.size() - 1) / 7 + 1));
        graphics.method_27534(this.field_22793, (class_2561)pageText, this.field_2776 + 228, this.field_2800 + 57, 0xFFFFFF);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.monster_type.title"), this.field_2776 + 147, this.field_2800 + 57, 0xFFFFFF);
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        super.method_2389(graphics, partialTicks, x, y);
        graphics.method_25302(BG, this.field_2776 + 80, this.field_2800 + 28, 0, 0, this.field_2792, 137);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && Screens.getClient((class_437)this).field_1724 != null) {
            Screens.getClient((class_437)this).field_1724.method_7346();
        }
        return this.inputField.method_25404(keyCode, scanCode, modifiers) || this.inputField.method_20315() || super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25419() {
        ClientPlayNetworking.send((class_2960)SetAttackListMessage.ID, (class_2540)SetAttackListMessage.encode(this.getMaid().method_5628(), this.attackGroups));
        super.method_25419();
    }

    public Map<class_2960, MonsterType> getAttackGroups() {
        return this.attackGroups;
    }
}

