/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4168;
import net.minecraft.class_4185;

public class ScheduleButton<T extends AbstractMaidContainer>
extends class_4185 {
    private static final class_2960 BUTTON = new class_2960("touhou_little_maid", "textures/gui/maid_gui_button.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private final EntityMaid maid;
    private MaidSchedule mode;

    public ScheduleButton(int x, int y, AbstractMaidContainerGui<T> gui) {
        super(x, y, 61, 13, (class_2561)class_2561.method_43473(), button -> {}, class_4185.field_40754);
        this.maid = gui.getMaid();
        this.mode = this.maid.getSchedule();
    }

    public void method_25306() {
        int index = this.mode.ordinal() + 1;
        int length = MaidSchedule.values().length;
        this.mode = MaidSchedule.values()[index % length];
        class_2540 buf = MaidConfigMessage.encode(this.maid.method_5628(), this.maid.isHomeModeEnable(), this.maid.isPickup(), this.maid.isRideable(), this.mode);
        ClientPlayNetworking.send((class_2960)MaidConfigMessage.ID, (class_2540)buf);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        graphics.method_25290(BUTTON, this.method_46426(), this.method_46427(), 82.0f, (float)(43 + 14 * this.mode.ordinal()), this.field_22758, this.field_22759, 256, 256);
    }

    public List<class_2561> getTooltips() {
        int time = (int)(this.maid.method_37908().method_8532() % 24000L);
        int hour = (time / 1000 + 6) % 24;
        int minute = time % 1000 * 60 / 1000;
        class_4168 activity = this.maid.getScheduleDetail();
        ArrayList out = Lists.newArrayList();
        out.add(class_2561.method_43470((String)String.format("\u00a7n%s\u00a77 %s:%s", this.getScheduleTransText(), DECIMAL_FORMAT.format(hour), DECIMAL_FORMAT.format(minute))));
        switch (this.mode) {
            case ALL: {
                out.add(class_2561.method_43470((String)String.format("\u00a7a\u2588 00:00-24:00 %s", this.getActivityTransText(class_4168.field_18596))));
                break;
            }
            case NIGHT: {
                if (activity == class_4168.field_18596) {
                    out.add(class_2561.method_43470((String)String.format("\u00a7a\u2588 18:00-06:00 %s", this.getActivityTransText(class_4168.field_18596))));
                } else {
                    out.add(class_2561.method_43470((String)String.format("\u00a78\u2588 18:00-06:00 %s", this.getActivityTransText(class_4168.field_18596))));
                }
                if (activity == class_4168.field_18597) {
                    out.add(class_2561.method_43470((String)String.format("\u00a7a\u2588 06:00-14:00 %s", this.getActivityTransText(class_4168.field_18597))));
                } else {
                    out.add(class_2561.method_43470((String)String.format("\u00a78\u2588 06:00-14:00 %s", this.getActivityTransText(class_4168.field_18597))));
                }
                if (activity == class_4168.field_18595) {
                    out.add(class_2561.method_43470((String)String.format("\u00a7a\u2588 14:00-18:00 %s", this.getActivityTransText(class_4168.field_18595))));
                    break;
                }
                out.add(class_2561.method_43470((String)String.format("\u00a78\u2588 14:00-18:00 %s", this.getActivityTransText(class_4168.field_18595))));
                break;
            }
            default: {
                if (activity == class_4168.field_18596) {
                    out.add(class_2561.method_43470((String)String.format("\u00a7a\u2588 06:00-18:00 %s", this.getActivityTransText(class_4168.field_18596))));
                } else {
                    out.add(class_2561.method_43470((String)String.format("\u00a78\u2588 06:00-18:00 %s", this.getActivityTransText(class_4168.field_18596))));
                }
                if (activity == class_4168.field_18595) {
                    out.add(class_2561.method_43470((String)String.format("\u00a7a\u2588 18:00-22:00 %s", this.getActivityTransText(class_4168.field_18595))));
                } else {
                    out.add(class_2561.method_43470((String)String.format("\u00a78\u2588 18:00-22:00 %s", this.getActivityTransText(class_4168.field_18595))));
                }
                if (activity == class_4168.field_18597) {
                    out.add(class_2561.method_43470((String)String.format("\u00a7a\u2588 22:00-06:00 %s", this.getActivityTransText(class_4168.field_18597))));
                    break;
                }
                out.add(class_2561.method_43470((String)String.format("\u00a78\u2588 22:00-06:00 %s", this.getActivityTransText(class_4168.field_18597))));
            }
        }
        out.add(class_2561.method_43471((String)"tooltips.touhou_little_maid.schedule.desc"));
        return out;
    }

    public String getScheduleTransText() {
        return class_1074.method_4662((String)("gui.touhou_little_maid.schedule." + this.mode.name().toLowerCase(Locale.US)), (Object[])new Object[0]);
    }

    public String getActivityTransText(class_4168 activity) {
        return class_1074.method_4662((String)("gui.touhou_little_maid.activity." + activity.method_19634()), (Object[])new Object[0]);
    }
}

