/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.input;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.Player2AppCheck;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.STTCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.DefaultLLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTSite;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3675;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class STTChatKey {
    public static final class_304 STT_CHAT_KEY = new class_304("key.touhou_little_maid.stt_chat.desc", class_3675.class_307.field_1668, 88, "key.category.touhou_little_maid");

    public static void onSttChatPress(int key, int scanCode, int action, int mods) {
        if (STTChatKey.keyIsMatch(key, scanCode, action, mods)) {
            if (!((Boolean)AIConfig.LLM_ENABLED.get()).booleanValue()) {
                return;
            }
            if (!((Boolean)AIConfig.STT_ENABLED.get()).booleanValue()) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null || player.method_7325()) {
                return;
            }
            if (!STTChatKey.isInGame()) {
                return;
            }
            STT_CHAT_KEY.method_1436();
            if (action == 1) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)InitSounds.RECORDING_START, (float)1.0f));
                STTChatKey.getNearestMaid(player, STTChatKey::sttStart, true);
                return;
            }
            if (action == 0) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)InitSounds.RECORDING_END, (float)1.0f));
                STTChatKey.getNearestMaid(player, STTChatKey::sttStop, false);
            }
        }
    }

    private static boolean keyIsMatch(int key, int scanCode, int action, int mods) {
        return STT_CHAT_KEY.method_1417(key, scanCode);
    }

    private static void getNearestMaid(class_746 player, Consumer<EntityMaid> consumer, boolean isStart) {
        class_1937 level = player.field_6002;
        int range = (Integer)AIConfig.MAID_CAN_CHAT_DISTANCE.get();
        class_238 aabb = player.method_5829().method_1014((double)range);
        List maids = level.method_8390(EntityMaid.class, aabb, maid -> maid.method_6171((class_1309)player) && maid.method_5805());
        maids.sort(Comparator.comparingDouble(maid -> maid.method_5858((class_1297)player)));
        if (!maids.isEmpty()) {
            consumer.accept((EntityMaid)maids.get(0));
            return;
        }
        if (isStart) {
            player.method_43496((class_2561)class_2561.method_43469((String)"ai.touhou_little_maid.chat.stt.no_maid_found", (Object[])new Object[]{range}));
        }
    }

    private static boolean isInGame() {
        class_310 mc = class_310.method_1551();
        if (mc.method_18506() != null) {
            return false;
        }
        if (mc.field_1755 != null) {
            return false;
        }
        if (!mc.field_1729.method_1613()) {
            return false;
        }
        return mc.method_1569();
    }

    private static void sttStart(EntityMaid maid) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        STTSite sttSite = AvailableSites.getSTTSite(((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName());
        if (!sttSite.enabled()) {
            player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.chat.stt.empty"));
            return;
        }
        if (sttSite.id().equals(DefaultLLMSite.PLAYER2.id())) {
            Player2AppCheck.checkPlayer2AppInStt((class_1657)player, () -> STTChatKey.tryToStart(maid, player, sttSite));
        } else {
            STTChatKey.tryToStart(maid, player, sttSite);
        }
    }

    private static void tryToStart(EntityMaid maid, class_746 player, STTSite sttSite) {
        STTConfig config = new STTConfig();
        STTCallback callback = new STTCallback((class_1657)player, maid);
        sttSite.client().startRecord(config, callback);
    }

    private static void sttStop(EntityMaid maid) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        STTSite sttSite = AvailableSites.getSTTSite(((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName());
        if (sttSite.enabled()) {
            STTConfig config = new STTConfig();
            STTCallback callback = new STTCallback((class_1657)player, maid);
            sttSite.client().stopRecord(config, callback);
        }
    }
}

