/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class FilePackTexture
extends SizeTexture {
    private final class_2960 texturePath;
    private final Path rootPath;
    private int width = 16;
    private int height = 16;

    public FilePackTexture(Path rootPath, class_2960 texturePath) {
        this.rootPath = rootPath;
        this.texturePath = texturePath;
    }

    @Override
    public boolean isExist() {
        File textureFile = this.rootPath.resolve("assets").resolve(this.texturePath.method_12836()).resolve(this.texturePath.method_12832()).toFile();
        return textureFile.isFile();
    }

    public void method_4625(class_3300 manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        File textureFile = this.rootPath.resolve("assets").resolve(this.texturePath.method_12836()).resolve(this.texturePath.method_12832()).toFile();
        if (textureFile.isFile()) {
            try (InputStream stream = Files.newInputStream(textureFile.toPath(), new OpenOption[0]);){
                class_1011 imageIn = class_1011.method_4309((InputStream)stream);
                this.width = imageIn.method_4307();
                this.height = imageIn.method_4323();
                TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)this.width, (int)this.height);
                imageIn.method_22619(0, 0, 0, 0, 0, this.width, this.height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

